/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.scope;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.classification.dt.QuickDtModel;
import ws.palladian.extraction.location.LocationExtractor;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.PalladianLocationExtractor;
import ws.palladian.extraction.location.disambiguation.FeatureBasedDisambiguation;
import ws.palladian.extraction.location.disambiguation.LocationDisambiguation;
import ws.palladian.extraction.location.scope.FeatureBasedScopeDetector;
import ws.palladian.extraction.location.scope.ScopeDetector;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.scope.ScopeDetectorNodeSettings;
import ws.palladian.nodes.extraction.location2.port.LocationSourcePortObject;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class ScopeDetectorNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final int INPORT_CONNECTOR = 0;
    static final int INPORT_TABLE = 1;
    private static final String LD_MODEL = "platform:/plugin/ws.palladian.nodes/resources/ld-all-training-10t.ser.gz";
    private static final String SD_MODEL = "platform:/plugin/ws.palladian.nodes/resources/sd-wikipedia-2014-training-10t.ser.gz";
    private final ScopeDetectorNodeSettings nodeSettings = new ScopeDetectorNodeSettings();
    private LocationSource locationSource;

    ScopeDetectorNodeModel() {
        super(new PortType[]{LocationSourcePortObject.TYPE, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE}, 1, 0);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        LocationSourcePortObject locationSourcePO = (LocationSourcePortObject)inObjects[0];
        this.locationSource = locationSourcePO.getSpec().createSource();
        BufferedDataTable inTable = (BufferedDataTable)inObjects[1];
        ColumnRearranger rearranger = this.createColumnRearranger(inTable.getDataTableSpec());
        BufferedDataTable outTable = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new PortObject[]{outTable};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = (DataTableSpec)inSpecs[1];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), StringValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.inputColumn.setStringValue(inColSpec.getName());
        }
        ColumnRearranger rearranger = this.createColumnRearranger(inSpec);
        DataTableSpec outSpec = rearranger.createSpec();
        return new PortObjectSpec[]{outSpec};
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        LazyInitializer<ScopeDetector> scopeDetectorInit = new LazyInitializer<ScopeDetector>(){

            protected ScopeDetector initialize() throws ConcurrentException {
                QuickDtModel ldModel = ScopeDetectorNodeModel.readModel(ScopeDetectorNodeModel.LD_MODEL);
                QuickDtModel sdModel = ScopeDetectorNodeModel.readModel(ScopeDetectorNodeModel.SD_MODEL);
                FeatureBasedDisambiguation disambiguation = new FeatureBasedDisambiguation(ldModel, 0.0);
                PalladianLocationExtractor locationExtractor = new PalladianLocationExtractor(ScopeDetectorNodeModel.this.locationSource, (LocationDisambiguation)disambiguation);
                return new FeatureBasedScopeDetector((LocationExtractor)locationExtractor, sdModel);
            }
        };
        final int textColumnIndex = spec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        String prefixString = Optional.ofNullable(this.nodeSettings.outputColumnPrefix.getStringValue()).orElse("");
        DataColumnSpec colSpec = new DataColumnSpecCreator(prefixString + "Scope", GeoCoordinateCell.TYPE).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec, (LazyInitializer)scopeDetectorInit){
            private final /* synthetic */ LazyInitializer val$scopeDetectorInit;
            {
                this.val$scopeDetectorInit = lazyInitializer;
                super($anonymous0);
            }

            public DataCell getCell(DataRow row) {
                ScopeDetector scopeDetector;
                DataCell cell = row.getCell(textColumnIndex);
                if (cell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String text = ((StringValue)cell).getStringValue();
                try {
                    scopeDetector = (ScopeDetector)this.val$scopeDetectorInit.get();
                }
                catch (ConcurrentException e) {
                    throw new IllegalStateException(e);
                }
                GeoCoordinate scope = scopeDetector.getScope(text);
                if (scope == null) {
                    return DataType.getMissingCell();
                }
                return new GeoCoordinateCell(scope);
            }

            public void afterProcessing() {
                if (ScopeDetectorNodeModel.this.locationSource instanceof Closeable) {
                    try {
                        ((Closeable)ScopeDetectorNodeModel.this.locationSource).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }

    private static QuickDtModel readModel(String modelUrl) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPInputStream inputStream = new GZIPInputStream(new URL(modelUrl).openConnection().getInputStream());){
                return (QuickDtModel)new ObjectInputStream(inputStream).readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }
}

