/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ws.palladian.nodes.extraction.location.source.LocationSourceSetting;

@Deprecated
public final class LocationSourceSettings {
    private static final List<LocationSourceSetting> DEFAULT = Collections.emptyList();
    private static final String PROPERTY_SEP = "\t";
    private static final String KEY_VALUE_SEP = "\u00a7\u00a7";
    private static final String SETTING_SEP = "\n";

    private LocationSourceSettings() {
    }

    public static String getStringValue(List<LocationSourceSetting> settings) {
        StringBuilder builder = new StringBuilder();
        for (LocationSourceSetting setting : settings) {
            builder.append(setting.isActive() ? "1" : "0").append(PROPERTY_SEP);
            builder.append(setting.getTitle()).append(PROPERTY_SEP);
            builder.append(setting.getTypeIdentifier());
            Set<Map.Entry<String, String>> properties = setting.getProperties().entrySet();
            for (Map.Entry<String, String> property : properties) {
                builder.append(PROPERTY_SEP);
                builder.append(property.getKey());
                builder.append(KEY_VALUE_SEP);
                builder.append(property.getValue());
            }
            builder.append(SETTING_SEP);
        }
        return builder.toString();
    }

    public static List<LocationSourceSetting> getSettings(String stringValue) {
        String[] settingsSplit;
        ArrayList<LocationSourceSetting> settings = new ArrayList<LocationSourceSetting>();
        String[] stringArray = settingsSplit = stringValue.split(SETTING_SEP);
        int n = settingsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String setting = stringArray[n2];
            String[] propertySplit = setting.split(PROPERTY_SEP);
            if (propertySplit.length >= 3) {
                boolean active = "1".equals(propertySplit[0]);
                String title = propertySplit[1];
                String typeIdentifier = propertySplit[2];
                HashMap<String, String> properties = new HashMap<String, String>();
                int i = 3;
                while (i < propertySplit.length) {
                    String[] keyValue = propertySplit[i].split(KEY_VALUE_SEP);
                    String value = keyValue.length > 1 ? keyValue[1] : "";
                    properties.put(keyValue[0], value);
                    ++i;
                }
                settings.add(new LocationSourceSetting(typeIdentifier, title, active, properties));
            }
            ++n2;
        }
        return settings;
    }

    public static String getDefaultStringValue() {
        return LocationSourceSettings.getStringValue(DEFAULT);
    }

    public static List<LocationSourceSetting> getDefaultSettings() {
        return DEFAULT;
    }
}

