/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.source.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.source.LocationSourceFactory;
import ws.palladian.nodes.extraction.location.source.LocationSourceRegistry;
import ws.palladian.nodes.extraction.location.source.LocationSourceSetting;
import ws.palladian.nodes.extraction.location.source.LocationSourceSettings;
import ws.palladian.nodes.extraction.location.source.preferences.LocationSourceWizard;

@Deprecated
public class LocationSourceTableEditor
extends FieldEditor {
    private Table table;
    private CheckboxTableViewer tableViewer;
    private Button buttonNew;
    private Button buttonEdit;
    private Button buttonRemove;

    public LocationSourceTableEditor(Composite parent) {
        this.init("ws.palldian.locationSources", "ATTENTION: These settings are only for the DEPRECATED \u201cLocation Extractor\u201d and \n\u201cReverse Location Lookup\u201d nodes. The new \u201cLocation Extractor\u201d and \u201cReverse \nLocation Lookup\u201d nodes are now configured through dedicated location source \nnodes. These settings are no longer necessary and will be ignored! \n");
        this.createControl(parent);
    }

    protected Label getLabelControl() {
        Label label = super.getLabelControl();
        Color colorObject = Display.getCurrent().getSystemColor(3);
        label.setForeground(colorObject);
        return label;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tableViewer.getControl().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        SelectionListener selectionListener = this.createSelectionListener();
        this.table = new Table(parent, 68388);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        if (SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_VERSION.startsWith("10.10")) {
            this.table.setHeaderVisible(false);
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LocationSourceTableEditor.this.table.setHeaderVisible(true);
                }
            });
        }
        this.table.setLayout((Layout)new TableLayout());
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gd);
        this.table.addSelectionListener(selectionListener);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setText("Title");
        tableColumn.setWidth(400);
        tableColumn.setResizable(true);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LocationSourceLabelProvider());
        this.tableViewer.setCheckStateProvider((ICheckStateProvider)new LocationCheckStateProvider());
        this.tableViewer.addCheckStateListener((ICheckStateListener)new LocationCheckStateListener());
        this.tableViewer.setComparator((ViewerComparator)new LocationSourceSettingViewerComparator());
        Composite buttonBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        buttonBox.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 1;
        buttonBox.setLayoutData((Object)gd);
        this.buttonNew = this.createButton(buttonBox, "Ne&w...", selectionListener);
        this.buttonEdit = this.createButton(buttonBox, "&Edit...", selectionListener);
        this.buttonRemove = this.createButton(buttonBox, "&Remove", selectionListener);
        this.selectionChanged();
    }

    private SelectionListener createSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget w = e.widget;
                if (w == LocationSourceTableEditor.this.table) {
                    LocationSourceTableEditor.this.selectionChanged();
                } else if (w == LocationSourceTableEditor.this.buttonNew) {
                    LocationSourceTableEditor.this.addPressed();
                } else if (w == LocationSourceTableEditor.this.buttonEdit) {
                    LocationSourceTableEditor.this.editPressed();
                } else if (w == LocationSourceTableEditor.this.buttonRemove) {
                    LocationSourceTableEditor.this.removePressed();
                }
            }
        };
    }

    private Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(listener);
        return button;
    }

    private void selectionChanged() {
        int index = this.table.getSelectionIndex();
        this.buttonEdit.setEnabled(index >= 0);
        this.buttonRemove.setEnabled(index >= 0);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        Collection<LocationSourceFactory> factories = LocationSourceRegistry.getFactories();
        LocationSourceWizard wizard = new LocationSourceWizard(factories);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            LocationSourceSetting setting = wizard.getSetting();
            this.tableViewer.add((Object)setting);
            this.selectionChanged();
        }
    }

    private Shell getShell() {
        return this.buttonNew.getShell();
    }

    private void editPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            final LocationSourceSetting setting = (LocationSourceSetting)this.table.getItem(index).getData();
            LocationSourceFactory factory = LocationSourceRegistry.getByTypeIdentifier(setting.getTypeIdentifier());
            if (factory == null) {
                MessageBox dialog = new MessageBox(this.getShell(), 40);
                dialog.setText("LocationSourceFactory not available");
                dialog.setMessage("The factory \"" + setting.getTypeIdentifier() + "\" is not available. You can either remove this source setting, or install the necessary plugin.");
                dialog.open();
                return;
            }
            final LocationSourceFactory.SourceSettingWizardPage wizardPage = factory.getWizardPage(setting);
            if (wizardPage != null) {
                Wizard wizard = new Wizard(){

                    public boolean performFinish() {
                        wizardPage.getSettings(setting);
                        return true;
                    }

                    public Image getDefaultPageImage() {
                        return PalladianPluginActivator.getDefault().getImage("/resources/1428063440_map_75.png");
                    }
                };
                wizard.addPage((IWizardPage)wizardPage);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        }
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            this.table.remove(index);
            this.selectionChanged();
        }
    }

    protected void doLoad() {
        String prefString = this.getPreferenceStore().getString(this.getPreferenceName());
        List<LocationSourceSetting> settings = LocationSourceSettings.getSettings(prefString);
        this.tableViewer.setInput(settings);
        this.tableViewer.refresh();
    }

    protected void doLoadDefault() {
        this.tableViewer.setInput(LocationSourceSettings.getDefaultSettings());
        this.tableViewer.refresh();
    }

    protected void doStore() {
        ArrayList<LocationSourceSetting> settings = new ArrayList<LocationSourceSetting>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            settings.add((LocationSourceSetting)tableItem.getData());
            ++n2;
        }
        String prefString = LocationSourceSettings.getStringValue(settings);
        this.getPreferenceStore().setValue(this.getPreferenceName(), prefString);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private static final class LocationCheckStateListener
    implements ICheckStateListener {
        private LocationCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            LocationSourceSetting s = (LocationSourceSetting)event.getElement();
            s.setActive(event.getChecked());
        }
    }

    private static final class LocationCheckStateProvider
    implements ICheckStateProvider {
        private LocationCheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            LocationSourceSetting setting = (LocationSourceSetting)element;
            LocationSourceFactory factory = LocationSourceRegistry.getByTypeIdentifier(setting.getTypeIdentifier());
            return factory == null;
        }

        public boolean isChecked(Object element) {
            return ((LocationSourceSetting)element).isActive();
        }
    }

    private static final class LocationSourceLabelProvider
    implements ITableLabelProvider {
        private LocationSourceLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                LocationSourceSetting setting = (LocationSourceSetting)element;
                LocationSourceFactory factory = LocationSourceRegistry.getByTypeIdentifier(setting.getTypeIdentifier());
                return factory != null ? factory.getIcon() : null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                LocationSourceSetting setting = (LocationSourceSetting)element;
                return setting.getTitle();
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class LocationSourceSettingViewerComparator
    extends ViewerComparator {
        private LocationSourceSettingViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            LocationSourceSetting s1 = (LocationSourceSetting)e1;
            LocationSourceSetting s2 = (LocationSourceSetting)e2;
            return s1.getTitle().compareTo(s2.getTitle());
        }
    }
}

