/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.utils;

import java.util.Collection;
import java.util.HashSet;
import org.knime.base.data.aggregation.AggregationOperator;
import org.knime.base.data.aggregation.GlobalSettings;
import org.knime.base.data.aggregation.OperatorColumnSettings;
import org.knime.base.data.aggregation.OperatorData;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import ws.palladian.helper.geo.GeoUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;

public class CenterOfMinimumDistanceOperator
extends AggregationOperator {
    private Collection<GeoCoordinateValue> values = new HashSet<GeoCoordinateValue>();

    public CenterOfMinimumDistanceOperator() {
        this(GlobalSettings.DEFAULT, OperatorColumnSettings.DEFAULT_EXCL_MISSING);
    }

    private CenterOfMinimumDistanceOperator(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        super(new OperatorData("Center of minimum distance", true, false, GeoCoordinateValue.class, false), globalSettings, opColSettings);
    }

    public String getDescription() {
        return "Calculates the geographical center of minimum distance for a group of GeoCoordinates, also known as \u201cmedian center\u201d or \u201cgeometric mean\u201d sometimes. This is the point which minimizes the sum of distances to all given points in the set.";
    }

    public AggregationOperator createInstance(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        return new CenterOfMinimumDistanceOperator(globalSettings, opColSettings);
    }

    protected boolean computeInternal(DataCell cell) {
        this.values.add((GeoCoordinateValue)cell);
        return false;
    }

    protected DataType getDataType(DataType origType) {
        return GeoCoordinateCell.TYPE;
    }

    protected DataCell getResultInternal() {
        return new GeoCoordinateCell(GeoUtils.getCenterOfMinimumDistance(this.values));
    }

    protected void resetInternal() {
        this.values.clear();
    }
}

