/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.utils;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.geo.GeoUtils;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.utils.LatitudeLongitudeToCoordinateNodeDialog;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public class LatitudeLongitudeToCoordinateNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(LatitudeLongitudeToCoordinateNodeModel.class);
    static final String CFGKEY_LAT_COLUMN = "inputLatColumn";
    static final String CFGKEY_LNG_COLUMN = "inputLngColumn";
    private final SettingsModelString settingLatColumn = LatitudeLongitudeToCoordinateNodeDialog.createSettingsLatColumn();
    private final SettingsModelString settingLngColumn = LatitudeLongitudeToCoordinateNodeDialog.createSettingsLngColumn();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        DataColumnSpec coordinateSpec = new DataColumnSpecCreator("Coordinate", GeoCoordinateCell.TYPE).createSpec();
        final int latIdx = dataTableSpec.findColumnIndex(this.settingLatColumn.getStringValue());
        final int lngIdx = dataTableSpec.findColumnIndex(this.settingLngColumn.getStringValue());
        SingleCellFactory factory = new SingleCellFactory(coordinateSpec){

            public DataCell getCell(DataRow row) {
                double lng;
                DataCell latCell = row.getCell(latIdx);
                DataCell lngCell = row.getCell(lngIdx);
                if (latCell.isMissing() || lngCell.isMissing()) {
                    logger.debug((Object)("Missing value(s) in row " + String.valueOf(row.getKey())));
                    return DataType.getMissingCell();
                }
                double lat = ((DoubleValue)latCell).getDoubleValue();
                if (GeoUtils.isValidCoordinateRange((double)lat, (double)(lng = ((DoubleValue)lngCell).getDoubleValue()))) {
                    return new GeoCoordinateCell(lat, lng);
                }
                logger.warn((Object)("Invalid latitude/longitude in row " + String.valueOf(row.getKey()) + ": " + lat + "," + lng));
                return DataType.getMissingCell();
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String columnName;
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec latSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingLatColumn.getStringValue(), DoubleValue.class);
        DataColumnSpec lngSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingLngColumn.getStringValue(), DoubleValue.class);
        ArrayList<String> guessedColumns = new ArrayList<String>();
        if (latSpec == null) {
            latSpec = PalladianKnimeHelper.guessColumnByName(inSpec, DoubleValue.class, "lat", "latitude");
            columnName = latSpec.getName();
            guessedColumns.add(columnName);
            this.settingLatColumn.setStringValue(columnName);
        }
        if (lngSpec == null) {
            lngSpec = PalladianKnimeHelper.guessColumnByName(inSpec, DoubleValue.class, "long", "lng", "longitude");
            columnName = lngSpec.getName();
            guessedColumns.add(columnName);
            this.settingLngColumn.setStringValue(columnName);
        }
        if (guessedColumns.size() > 0) {
            String warningMessage = String.format("Guessed column name(s): %s", StringUtils.join(guessedColumns, (String)", "));
            this.setWarningMessage(warningMessage);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingLatColumn.saveSettingsTo(settings);
        this.settingLngColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingLatColumn.loadSettingsFrom(settings);
        this.settingLngColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingLatColumn.validateSettings(settings);
        this.settingLngColumn.validateSettings(settings);
    }
}

