/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.waypointrenderer;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jxmapviewer.JXMapViewer;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeView;

public class CircleWaypointRenderer
extends InfoWaypointRenderer {
    @Override
    protected void paintShape(Graphics2D g, JXMapViewer map, InfoWaypoint waypoint, Point2D point) {
        Shape originalShape = this.getShape(g, waypoint);
        Shape shape = MapViewer2NodeView.move(originalShape, point.getX(), point.getY());
        g.setStroke(new BasicStroke(4.0f));
        if (waypoint.isSelected()) {
            g.setPaint(SELECTED_COLOR);
            g.draw(shape);
        } else if (waypoint.isHilited()) {
            g.setPaint(HILITED_COLOR);
            g.draw(shape);
        }
        g.setPaint(waypoint.getColor());
        g.fill(shape);
    }

    @Override
    public Shape getShape(Graphics2D g, InfoWaypoint waypoint) {
        double size = waypoint.getSize();
        float xy = Math.round(-5.0 * size);
        float wh = Math.round(10.0 * size);
        return new Ellipse2D.Float(xy, xy, wh, wh);
    }

    @Override
    public String getName() {
        return "Circle";
    }
}

