/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.waypointrenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jxmapviewer.JXMapViewer;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeView;

public class DropWaypointRenderer
extends InfoWaypointRenderer {
    @Override
    protected void paintShape(Graphics2D g, JXMapViewer map, InfoWaypoint waypoint, Point2D point) {
        Shape originalShape = this.getShape(g, waypoint);
        Shape shape = MapViewer2NodeView.move(originalShape, point.getX(), point.getY());
        Color borderColor = waypoint.isSelected() ? SELECTED_COLOR : (waypoint.isHilited() ? HILITED_COLOR : DEFAULT_BORDER_COLOR);
        g.setStroke(new BasicStroke(4.0f));
        g.setPaint(borderColor);
        g.draw(shape);
        g.setPaint(waypoint.getColor());
        g.fill(shape);
    }

    @Override
    public Shape getShape(Graphics2D g, InfoWaypoint waypoint) {
        long widthHeight = Math.round(10.0 * waypoint.getSize());
        return new Drop(widthHeight, widthHeight);
    }

    @Override
    public String getName() {
        return "Teardrop";
    }

    static final class Drop
    extends Path2D.Float {
        private static final long serialVersionUID = 1L;

        Drop(float width, float height) {
            super(new Arc2D.Float(-width / 2.0f, -height - width / 2.0f, width, width, 330.0f, 240.0f, 0));
            this.lineTo(0.0f, 0.0f);
            this.closePath();
        }
    }
}

