/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.waypointrenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import org.jxmapviewer.JXMapViewer;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeView;

public class LabelWaypointRenderer
extends InfoWaypointRenderer {
    private static final String DUMMY_LABEL = "### no label ###";

    @Override
    protected void paintShape(Graphics2D g, JXMapViewer map, InfoWaypoint waypoint, Point2D point) {
        Shape originalShape = this.getShape(g, waypoint);
        Shape shape = MapViewer2NodeView.move(originalShape, point.getX(), point.getY());
        g.setStroke(new BasicStroke(4.0f));
        if (waypoint.isSelected()) {
            g.setPaint(SELECTED_COLOR);
            g.draw(shape);
        } else if (waypoint.isHilited()) {
            g.setPaint(HILITED_COLOR);
            g.draw(shape);
        }
        g.setPaint(waypoint.getColor());
        g.fill(shape);
        int rectangleWidth = this.getRectangleWidth(g, waypoint);
        g.setPaint(LabelWaypointRenderer.getContrast(waypoint.getColor()));
        g.drawString(this.getLabel(waypoint), (float)point.getX() - (float)(rectangleWidth / 2), (float)point.getY() - 16.0f);
    }

    private String getLabel(InfoWaypoint waypoint) {
        if (waypoint.getLabel() == null || waypoint.getLabel().isEmpty()) {
            return DUMMY_LABEL;
        }
        return waypoint.getLabel();
    }

    private int getRectangleWidth(Graphics2D g, InfoWaypoint waypoint) {
        int width = (int)g.getFontMetrics().getStringBounds(this.getLabel(waypoint), g).getWidth();
        return width;
    }

    private static final Color getContrast(Color color) {
        double luminance = Math.sqrt(0.299 * Math.pow(color.getRed(), 2.0) + 0.587 * Math.pow(color.getGreen(), 2.0) + 0.114 * Math.pow(color.getBlue(), 2.0));
        return luminance > 128.0 ? Color.BLACK : Color.WHITE;
    }

    @Override
    public Shape getShape(Graphics2D g, InfoWaypoint waypoint) {
        Polygon triangle = new Polygon();
        triangle.addPoint(0, 0);
        triangle.addPoint(11, -11);
        triangle.addPoint(-11, -11);
        int width = this.getRectangleWidth(g, waypoint);
        RoundRectangle2D.Float rectangle = new RoundRectangle2D.Float(-width / 2 - 5, -30.0f, width + 10, 20.0f, 10.0f, 10.0f);
        Area area = new Area(triangle);
        area.add(new Area(rectangle));
        return area;
    }

    @Override
    public String getName() {
        return "Label";
    }
}

