/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.extractor;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelDouble;
import org.knime.core.node.defaultnodesettings.SettingsModelDoubleBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.disambiguation.LocationDisambiguation;
import ws.palladian.nodes.extraction.location2.extractor.LocationExtractor2NodeModel;

class LocationExtractor2NodeSettings {
    private static final String CFGKEY_INPUT_COLUMN_NAME = "settingInputColumn";
    private static final String CFGKEY_OUTPUT_COLUMN_PREFIX = "outputColumnPrefix";
    private static final String CFGKEY_OUTPUT_MAPPING = "outputMapping";
    private static final String CFGKEY_DISAMBIGUATION_METHOD = "dismbiguationMethod";
    private static final String CFGKEY_DISAMBIGUATION_TRUST = "disambiguationTrust";
    private static final double DEFAULT_DISAMBIGUATION_TRUST = 0.1;
    final SettingsModelString inputColumn = new SettingsModelString("settingInputColumn", null);
    final SettingsModelString outputColumnPrefix = new SettingsModelString("outputColumnPrefix", null);
    final SettingsModelString outputMapping;
    final SettingsModelString disambiguationMethod;
    final SettingsModelDouble disambiguationTrust;

    LocationExtractor2NodeSettings() {
        this.outputMapping = new SettingsModelString(CFGKEY_OUTPUT_MAPPING, LocationExtractor2NodeModel.MappingStrategy.ROWS_OR_MISSING.label);
        this.disambiguationMethod = new SettingsModelString(CFGKEY_DISAMBIGUATION_METHOD, LocationExtractor2NodeModel.DisambiguationMethod.ML_ALL.label);
        this.disambiguationTrust = new SettingsModelDoubleBounded(CFGKEY_DISAMBIGUATION_TRUST, 0.1, 0.0, 1.0);
        this.disambiguationMethod.addChangeListener(l -> this.disambiguationTrust.setEnabled(this.getDisambiguationMethod().supportsTrust()));
    }

    void saveSettings(NodeSettingsWO settings) {
        this.inputColumn.saveSettingsTo(settings);
        this.outputColumnPrefix.saveSettingsTo(settings);
        this.outputMapping.saveSettingsTo(settings);
        this.disambiguationMethod.saveSettingsTo(settings);
        this.disambiguationTrust.saveSettingsTo(settings);
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.loadSettingsFrom(settings);
        this.outputColumnPrefix.loadSettingsFrom(settings);
        this.outputMapping.loadSettingsFrom(settings);
        this.disambiguationMethod.loadSettingsFrom(settings);
        this.disambiguationTrust.loadSettingsFrom(settings);
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.validateSettings(settings);
        this.outputColumnPrefix.validateSettings(settings);
        this.outputMapping.validateSettings(settings);
        this.disambiguationMethod.validateSettings(settings);
        this.disambiguationTrust.validateSettings(settings);
    }

    LocationExtractor2NodeModel.MappingStrategy getMappingStrategy() {
        return LocationExtractor2NodeModel.MappingStrategy.getByLabel(this.outputMapping.getStringValue());
    }

    LocationDisambiguation getDisambiguation() throws Exception {
        return this.getDisambiguationMethod().createDisambiguation(this);
    }

    private LocationExtractor2NodeModel.DisambiguationMethod getDisambiguationMethod() {
        return LocationExtractor2NodeModel.DisambiguationMethod.getByLabel(this.disambiguationMethod.getStringValue());
    }
}

