/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location2.source.local;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;
import ws.palladian.extraction.location.persistence.lucene.LuceneLocationSource;
import ws.palladian.nodes.extraction.location2.port.AbstractLocationSourcePortObjectSpec;
import ws.palladian.nodes.extraction.location2.source.local.LocalLocationSourceNodeSettings;

public final class LocalLocationSourcePortObjectSpec
extends AbstractLocationSourcePortObjectSpec {
    private String directoryPath;

    public LocalLocationSourcePortObjectSpec() {
    }

    LocalLocationSourcePortObjectSpec(LocalLocationSourceNodeSettings nodeSettings) {
        this.directoryPath = nodeSettings.directoryPath.getStringValue();
    }

    protected void save(ModelContentWO model) {
        model.addString("directoryPath", this.directoryPath);
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.directoryPath = model.getString("directoryPath");
    }

    public LuceneLocationSource createSource() throws Exception {
        return new LuceneLocationSource((Directory)FSDirectory.open((Path)Paths.get(this.directoryPath, new String[0])));
    }

    @Override
    protected String getSummary() {
        return "Directory: " + this.directoryPath;
    }

    public static final class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<LocalLocationSourcePortObjectSpec> {
    }
}

