/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.regex2;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.philippkatz.regextractor.RegExTractor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.knime.base.data.filter.column.FilterColumnRow;
import org.knime.base.data.filter.column.FilterColumnTable;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.InputPortRole;
import org.knime.core.node.streamable.OutputPortRole;
import org.knime.core.node.streamable.PartitionInfo;
import org.knime.core.node.streamable.PortInput;
import org.knime.core.node.streamable.PortOutput;
import org.knime.core.node.streamable.RowInput;
import org.knime.core.node.streamable.RowOutput;
import org.knime.core.node.streamable.StreamableOperator;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.regex2.RegexExtractor2NodeSettings;

class RegexExtractor2NodeModel
extends NodeModel {
    static final String MATCHINDEX_PLACEHOLDER = "$MATCHINDEX";
    private final RegexExtractor2NodeSettings nodeSettings = new RegexExtractor2NodeSettings();

    RegexExtractor2NodeModel(PortType[] inputPorts) {
        super(inputPorts, new PortType[]{BufferedDataTable.TYPE});
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        boolean tableConnected = this.getNrInPorts() == 1;
        BufferedDataTable inTable = tableConnected ? inData[0] : this.nodeSettings.createDummyInTable();
        RegExTractor extractor = this.nodeSettings.createExtractor();
        long inRowCount = tableConnected ? inTable.size() : 1L;
        String inColName = tableConnected ? this.nodeSettings.getInputColumnName() : "text";
        int inCellIndex = inTable.getDataTableSpec().findColumnIndex(inColName);
        boolean dropInputColumn = !tableConnected || this.nodeSettings.isDropInputColumn();
        int maxMatchCount = 0;
        if (this.nodeSettings.getMapping() == RegexExtractor2NodeSettings.Mapping.COLUMNS) {
            ExecutionMonitor progress = exec.createSubProgress(0.5);
            long inRowIndex = 0L;
            for (DataRow row : inTable) {
                progress.setProgress((double)inRowIndex++ / (double)inRowCount, "Determine result table structure \u2026 row " + inRowIndex + " / " + inRowCount);
                progress.checkCanceled();
                DataCell cell = row.getCell(inCellIndex);
                if (cell.isMissing()) continue;
                String text = ((StringValue)cell).getStringValue();
                RegExTractor.Result result = extractor.extract(text);
                maxMatchCount = Math.max(maxMatchCount, result.getMatches().size());
            }
        }
        DataTableSpec outSpec = this.createSpec(inTable.getDataTableSpec(), tableConnected, maxMatchCount);
        BufferedDataContainer container = exec.createDataContainer(outSpec);
        long inRowIndex = 0L;
        ExecutionMonitor progress = exec.createSubProgress(this.nodeSettings.getMapping() == RegexExtractor2NodeSettings.Mapping.COLUMNS ? 0.5 : 1.0);
        for (DataRow originalRow : inTable) {
            List<DataRow> extractedRows = this.process(originalRow, extractor, inCellIndex, maxMatchCount, dropInputColumn, tableConnected, exec);
            extractedRows.forEach(arg_0 -> ((BufferedDataContainer)container).addRowToTable(arg_0));
            progress.checkCanceled();
            progress.setProgress((double)(++inRowIndex) / (double)inRowCount, "Extracting \u2026 row " + inRowIndex + " / " + inRowCount);
        }
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new BufferedDataTable[]{outTable};
    }

    private List<DataRow> process(DataRow row, RegExTractor extractor, int inCellIndex, int maxMatchCount, boolean removeInputColumn, boolean tableConnected, ExecutionContext exec) throws Exception {
        int numAppendedCells;
        DataCell cell = row.getCell(inCellIndex);
        RegExTractor.Result result = null;
        if (!cell.isMissing()) {
            String text = ((StringValue)cell).getStringValue();
            ExecutionContextCharSequence interruptibleCharSequence = new ExecutionContextCharSequence(text, (ExecutionMonitor)exec);
            result = extractor.extract(interruptibleCharSequence);
        }
        List<Object> extractedRows = new LinkedList<DataRow>();
        switch (this.nodeSettings.getMapping()) {
            case ROWS: 
            case ROWS_OR_MISSING: {
                int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                numAppendedCells = extractor.getGroupCount() + (this.nodeSettings.isAppendInputId() ? 1 : 0) - startIdx;
                boolean didMatch = false;
                long outRowIndex = 0L;
                if (result != null) {
                    for (RegExTractor.Match match2 : result) {
                        RowKey rowKey;
                        DataCell[] cells = new DataCell[numAppendedCells];
                        int groupIdx = startIdx;
                        while (groupIdx < extractor.getGroupCount()) {
                            String value2 = match2.group(groupIdx).getValue();
                            cells[groupIdx - startIdx] = value2 != null ? new StringCell(value2) : DataType.getMissingCell();
                            ++groupIdx;
                        }
                        if (this.nodeSettings.isAppendInputId()) {
                            cells[numAppendedCells - 1] = new StringCell(row.getKey().getString());
                        }
                        if (tableConnected) {
                            StringBuilder id = new StringBuilder().append(row.getKey().getString());
                            if (result.matchCount() > 1) {
                                id.append("#").append(outRowIndex);
                                ++outRowIndex;
                            }
                            rowKey = new RowKey(id.toString());
                        } else {
                            rowKey = RowKey.createRowKey((long)outRowIndex);
                            ++outRowIndex;
                        }
                        extractedRows.add((DataRow)new AppendedColumnRow(rowKey, row, cells));
                        didMatch = true;
                    }
                }
                if (didMatch || this.nodeSettings.getMapping() != RegexExtractor2NodeSettings.Mapping.ROWS_OR_MISSING) break;
                Object[] cells = new DataCell[numAppendedCells];
                Arrays.fill(cells, DataType.getMissingCell());
                if (this.nodeSettings.isAppendInputId()) {
                    cells[numAppendedCells - 1] = new StringCell(row.getKey().getString());
                }
                extractedRows.add((DataRow)new AppendedColumnRow(row.getKey(), row, (DataCell[])cells));
                break;
            }
            case SINGLE_ROW: {
                int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                numAppendedCells = extractor.getGroupCount() - startIdx;
                DataCell[] cells = new DataCell[numAppendedCells];
                int groupIdx = startIdx;
                while (groupIdx < extractor.getGroupCount()) {
                    String value3 = result != null && result.matchCount() > 0 ? result.match(0).group(groupIdx).getValue() : null;
                    cells[groupIdx - startIdx] = value3 != null ? new StringCell(value3) : DataType.getMissingCell();
                    ++groupIdx;
                }
                extractedRows.add((DataRow)new AppendedColumnRow(row, cells));
                break;
            }
            case COLUMNS: {
                if (maxMatchCount < 0) {
                    throw new IllegalArgumentException("maxMatchCount is not known");
                }
                int startIdx = this.nodeSettings.isDropFullMatchColumn() ? 1 : 0;
                numAppendedCells = maxMatchCount * (extractor.getGroupCount() - startIdx);
                Object[] cells = new DataCell[numAppendedCells];
                Arrays.fill(cells, DataType.getMissingCell());
                int arrayIdx = 0;
                if (result != null) {
                    for (RegExTractor.Match match3 : result) {
                        int groupIdx = startIdx;
                        while (groupIdx < match3.groupCount()) {
                            String value4 = match3.group(groupIdx).getValue();
                            cells[arrayIdx] = value4 != null ? new StringCell(value4) : DataType.getMissingCell();
                            ++arrayIdx;
                            ++groupIdx;
                        }
                    }
                }
                extractedRows.add((DataRow)new AppendedColumnRow(row, (DataCell[])cells));
                break;
            }
            case JSON: {
                numAppendedCells = 1;
                String json = new ObjectMapper().writeValueAsString((Object)result);
                DataCell resultCell = result != null ? JSONCellFactory.create((String)json, (boolean)false) : DataType.getMissingCell();
                extractedRows.add(new AppendedColumnRow(row, new DataCell[]{resultCell}));
                break;
            }
            case LIST: {
                numAppendedCells = 1;
                List<Object> cells = new ArrayList();
                if (result != null) {
                    cells = result.getMatches().stream().flatMap(match -> match.getGroups().stream().skip(this.nodeSettings.isDropFullMatchColumn() ? 1 : 0)).filter(group -> group.getValue() != null).map(group -> new StringCell(group.getValue())).collect(Collectors.toList());
                }
                ListCell resultCell = CollectionCellFactory.createListCell(cells);
                extractedRows.add(new AppendedColumnRow(row, new DataCell[]{resultCell}));
                break;
            }
            case IS_MATCH: {
                numAppendedCells = 1;
                boolean match4 = result != null ? result.matchCount() > 0 : false;
                extractedRows.add(new AppendedColumnRow(row, new DataCell[]{BooleanCell.BooleanCellFactory.create((boolean)match4)}));
                break;
            }
            case MATCH_COUNT: {
                numAppendedCells = 1;
                int matchCount = result != null ? result.matchCount() : 0;
                extractedRows.add(new AppendedColumnRow(row, new DataCell[]{new IntCell(matchCount)}));
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented: " + String.valueOf((Object)this.nodeSettings.getMapping()));
            }
        }
        if (removeInputColumn) {
            int[] colIndicesToKeep = IntStream.range(0, row.getNumCells() + numAppendedCells).filter(value -> value != inCellIndex).toArray();
            extractedRows = extractedRows.stream().map(currentRow -> new FilterColumnRow(currentRow, colIndicesToKeep)).collect(Collectors.toCollection(LinkedList::new));
        }
        return extractedRows;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec;
        boolean tableConnected = this.getNrInPorts() == 1;
        DataTableSpec dataTableSpec = inSpec = tableConnected ? inSpecs[0] : this.nodeSettings.createDummyInTable().getDataTableSpec();
        if (tableConnected) {
            DataColumnSpec inColSpec = inSpec.getColumnSpec(this.nodeSettings.getInputColumnName());
            if (inColSpec == null) {
                throw new InvalidSettingsException("Please configure an input column.");
            }
            if (!inColSpec.getType().isCompatible(StringValue.class)) {
                throw new InvalidSettingsException(String.format("Column %s is not a StringValue; please reconfigure the node.", this.nodeSettings.getInputColumnName()));
            }
        }
        DataTableSpec outSpec = this.createSpec(inSpec, tableConnected, -1);
        return new DataTableSpec[]{outSpec};
    }

    private DataTableSpec createSpec(DataTableSpec inSpec, boolean tableConnected, int maxMatchCount) throws InvalidSettingsException {
        DataTableSpec modifiedInSpec = inSpec;
        if (!tableConnected || this.nodeSettings.isDropInputColumn()) {
            String inColName = tableConnected ? this.nodeSettings.getInputColumnName() : "text";
            int inCellIndex = inSpec.findColumnIndex(inColName);
            modifiedInSpec = FilterColumnTable.createFilterTableSpec((DataTableSpec)modifiedInSpec, (boolean)false, (int[])new int[]{inCellIndex});
        }
        DataTableSpecCreator specCreator = new DataTableSpecCreator(modifiedInSpec);
        String nameOrPrefix = Optional.ofNullable(this.nodeSettings.getOutputColumnNameOrPrefix()).orElse("");
        RegExTractor extractor = this.nodeSettings.createExtractor();
        ArrayList<String> groupNames = new ArrayList<String>(extractor.getGroupNames());
        if (this.nodeSettings.isDropFullMatchColumn()) {
            groupNames.remove("Full Match");
        }
        if (groupNames.isEmpty()) {
            this.setWarningMessage("No result columns will be appended. Either define at least one capturing group, or disable the \u201cNo Full Match\u201d option.");
        }
        switch (this.nodeSettings.getMapping()) {
            case ROWS: 
            case ROWS_OR_MISSING: {
                groupNames.forEach(name -> {
                    DataTableSpecCreator dataTableSpecCreator2 = specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + name, StringCell.TYPE).createSpec()});
                });
                if (!this.nodeSettings.isAppendInputId()) break;
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + "RowID", StringCell.TYPE).createSpec()});
                break;
            }
            case SINGLE_ROW: {
                groupNames.forEach(name -> {
                    DataTableSpecCreator dataTableSpecCreator2 = specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix + name, StringCell.TYPE).createSpec()});
                });
                break;
            }
            case COLUMNS: {
                if (!nameOrPrefix.contains(MATCHINDEX_PLACEHOLDER)) {
                    throw new InvalidSettingsException("The \u201cPrefix\u201d must contain a placeholder $MATCHINDEX for the match index");
                }
                if (maxMatchCount == -1) {
                    return null;
                }
                int i = 0;
                while (i < maxMatchCount) {
                    String currentPrefix = nameOrPrefix.replace(MATCHINDEX_PLACEHOLDER, String.valueOf(i));
                    groupNames.forEach(name -> specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(currentPrefix + name, StringCell.TYPE).createSpec()}));
                    ++i;
                }
                break;
            }
            case JSON: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, JSONCell.TYPE).createSpec()});
                break;
            }
            case LIST: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
                break;
            }
            case IS_MATCH: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, BooleanCell.TYPE).createSpec()});
                break;
            }
            case MATCH_COUNT: {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(nameOrPrefix, IntCell.TYPE).createSpec()});
                break;
            }
            default: {
                throw new InvalidSettingsException("Unimplemented: " + String.valueOf((Object)this.nodeSettings.getMapping()));
            }
        }
        return specCreator.createSpec();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        new RegexExtractor2NodeSettings().loadSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void reset() {
    }

    public InputPortRole[] getInputPortRoles() {
        return new InputPortRole[]{InputPortRole.DISTRIBUTED_STREAMABLE};
    }

    public OutputPortRole[] getOutputPortRoles() {
        return new OutputPortRole[]{OutputPortRole.DISTRIBUTED};
    }

    public StreamableOperator createStreamableOperator(PartitionInfo partitionInfo, PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        PalladianPluginActivator.checkLicense();
        if (this.nodeSettings.getMapping() == RegexExtractor2NodeSettings.Mapping.COLUMNS) {
            throw new InvalidSettingsException("Output type \u201cColumns\u201d is not supoorted in streaming mode; please disable streaming or select a different output setting.");
        }
        if (this.getNrInPorts() == 0) {
            throw new InvalidSettingsException("When running in streaming mode, an input table must be connected");
        }
        DataTableSpec inputSpec = (DataTableSpec)inSpecs[0];
        final RegExTractor extractor = this.nodeSettings.createExtractor();
        String inColName = this.nodeSettings.getInputColumnName();
        final int inCellIndex = inputSpec.findColumnIndex(inColName);
        final boolean dropInputColumn = this.nodeSettings.isDropInputColumn();
        return new StreamableOperator(){

            public void runFinal(PortInput[] inputs, PortOutput[] outputs, ExecutionContext exec) throws Exception {
                DataRow row;
                RowInput input = (RowInput)inputs[0];
                RowOutput output = (RowOutput)outputs[0];
                while ((row = input.poll()) != null) {
                    exec.checkCanceled();
                    exec.setProgress("Extracting \u2026 row " + String.valueOf(row.getKey()));
                    List<DataRow> extractedRows = RegexExtractor2NodeModel.this.process(row, extractor, inCellIndex, -1, dropInputColumn, true, exec);
                    for (DataRow extractedRow : extractedRows) {
                        output.push(extractedRow);
                    }
                }
                input.close();
                output.close();
            }
        };
    }

    private static final class ExecutionContextCharSequence
    implements CharSequence {
        private static final int CHECK_EVERY_NTH_CALL = 100;
        private final CharSequence inner;
        private final ExecutionMonitor exec;
        private long callCount = 0L;

        private ExecutionContextCharSequence(CharSequence inner, ExecutionMonitor exec) {
            this.inner = inner;
            this.exec = exec;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ExecutionContextCharSequence(this.inner.subSequence(start, end), this.exec);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public char charAt(int index) {
            this.checkTimeout();
            return this.inner.charAt(index);
        }

        private void checkTimeout() {
            if (this.callCount++ % 100L != 0L) {
                return;
            }
            try {
                this.exec.checkCanceled();
            }
            catch (CanceledExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

