/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.Tile;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.WaypointPainter;
import org.jxmapviewer.viewer.WaypointRenderer;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.image.ImageContent;
import org.knime.core.data.image.png.PNGImageContent;
import org.knime.core.data.property.ColorAttr;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettings;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.image.ImagePortObject;
import org.knime.core.node.port.image.ImagePortObjectSpec;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.InfoWaypoint;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeSettings;
import ws.palladian.nodes.geo.mapviewer2.MapViewer2NodeView;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class MapViewer2NodeModel
extends NodeModel {
    static final int LOCATION_TABLE_IDX = 0;
    private static final String WAYPOINTS_FILE_NAME = "waypoints.xml";
    private final MapViewer2NodeSettings nodeSettings = new MapViewer2NodeSettings();
    private final Set<InfoWaypoint> waypoints = new LinkedHashSet<InfoWaypoint>();

    MapViewer2NodeModel(PortType[] outputPorts) {
        super(new PortType[]{BufferedDataTable.TYPE}, outputPorts);
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inputTable = (BufferedDataTable)inData[0];
        DataTableSpec inputSpec = inputTable.getDataTableSpec();
        int inputColIndex = inputSpec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        if (inputColIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + inputColIndex + "). Please (re)configure the node correctly.");
        }
        int labelColIndex = inputSpec.findColumnIndex(this.nodeSettings.labelColumn.getStringValue());
        long index = 0L;
        long rowCount = inputTable.size();
        HashSet<Integer> coordinateDuplicateCheck = new HashSet<Integer>();
        for (DataRow row : inputTable) {
            GeoCoordinateValue geoCoordinate;
            DataCell geoCell = row.getCell(inputColIndex);
            if (geoCell.isMissing() || !coordinateDuplicateCheck.add((geoCoordinate = (GeoCoordinateValue)geoCell).hashCode())) continue;
            ColorAttr rowColor = inputSpec.getRowColor(row);
            Color color = rowColor.getColor();
            double size = inputSpec.getRowSizeFactor(row);
            String label = "";
            if (labelColIndex != -1 && !row.getCell(labelColIndex).isMissing()) {
                label = ((StringValue)row.getCell(labelColIndex)).getStringValue();
            }
            this.waypoints.add(new InfoWaypoint(geoCoordinate, color, label, size, row.getKey()));
            exec.checkCanceled();
            exec.setProgress((double)index / (double)rowCount, "Processing row " + index);
            ++index;
        }
        if (this.getNrOutPorts() == 1) {
            ImagePortObject imagePortObject = new ImagePortObject((ImageContent)this.renderMapImage(), new ImagePortObjectSpec(PNGImageContent.TYPE));
            return new PortObject[]{imagePortObject};
        }
        return new PortObject[0];
    }

    private PNGImageContent renderMapImage() throws InterruptedException, IOException {
        JFrame frame = new JFrame();
        try {
            JXMapViewer mapViewer = new JXMapViewer();
            final AtomicInteger numLoadingTiles = new AtomicInteger(0);
            CountDownLatch finishedLoadingAllTiles = new CountDownLatch(1);
            DefaultTileFactory tileFactory = new DefaultTileFactory(this.nodeSettings.getTileFactoryInfo()){

                protected synchronized void startLoading(Tile tile) {
                    numLoadingTiles.incrementAndGet();
                    super.startLoading(tile);
                }
            };
            tileFactory.addTileListener(tile -> {
                if (numLoadingTiles.decrementAndGet() == 0) {
                    finishedLoadingAllTiles.countDown();
                }
            });
            tileFactory.setThreadPoolSize(8);
            mapViewer.setTileFactory((TileFactory)tileFactory);
            WaypointPainter painter = new WaypointPainter();
            painter.setRenderer((WaypointRenderer)this.nodeSettings.getRenderer());
            painter.setWaypoints(this.getWaypoints());
            mapViewer.setOverlayPainter((Painter)painter);
            frame.getContentPane().add((Component)mapViewer);
            frame.setSize(this.nodeSettings.width.getIntValue(), this.nodeSettings.height.getIntValue());
            frame.setUndecorated(true);
            frame.setVisible(true);
            MapViewer2NodeView.showAll(mapViewer, (WaypointPainter<InfoWaypoint>)painter);
            finishedLoadingAllTiles.await();
            Dimension size = frame.getSize();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics2D graphics = image.createGraphics();
            frame.paintAll(graphics);
            graphics.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            PNGImageContent pNGImageContent = new PNGImageContent(outputStream.toByteArray());
            return pNGImageContent;
        }
        finally {
            frame.dispose();
        }
    }

    protected void reset() {
        this.waypoints.clear();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = (DataTableSpec)inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), GeoCoordinateValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.inputColumn.setStringValue(inColSpec.getName());
        }
        if (this.getNrOutPorts() == 1) {
            return new PortObjectSpec[]{new ImagePortObjectSpec(PNGImageContent.TYPE)};
        }
        return new PortObjectSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(internDir, WAYPOINTS_FILE_NAME)));){
                NodeSettingsRO settings = NodeSettings.loadFromXML((InputStream)in);
                int numLocations = settings.getInt("numLocations");
                int i = 0;
                while (i < numLocations) {
                    NodeSettingsRO locSetting = settings.getNodeSettings("l_" + i);
                    double lat = locSetting.getDouble("lat");
                    double lng = locSetting.getDouble("lng");
                    Color color = new Color(locSetting.getInt("color"));
                    String label = locSetting.getString("label");
                    RowKey rowKey = locSetting.getRowKey("rowKey");
                    double size = locSetting.containsKey("size") ? locSetting.getDouble("size") : 1.0;
                    this.waypoints.add(new InfoWaypoint(lat, lng, color, label, size, rowKey));
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.setWarningMessage("Error while restoring the view state: " + e.toString() + ". Reset and re-run the node to get the view. Sorry.");
        }
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(internDir, WAYPOINTS_FILE_NAME)));){
            NodeSettings settings = new NodeSettings("LocationViewer");
            settings.addInt("numLocations", this.waypoints.size());
            int i = 0;
            for (InfoWaypoint wp : this.waypoints) {
                NodeSettingsWO locSetting = settings.addNodeSettings("l_" + i++);
                locSetting.addDouble("lat", wp.getPosition().getLatitude());
                locSetting.addDouble("lng", wp.getPosition().getLongitude());
                locSetting.addInt("color", wp.getColor().getRGB());
                locSetting.addString("label", wp.getLabel());
                locSetting.addRowKey("rowKey", wp.getRowKey());
                locSetting.addDouble("size", wp.getSize());
            }
            settings.saveToXML((OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Set<InfoWaypoint> getWaypoints() {
        return this.waypoints;
    }

    MapViewer2NodeSettings getNodeSettings() {
        return this.nodeSettings;
    }
}

