/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.VirtualEarthTileFactoryInfo;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.extraction.location.tiles.AppleTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.StamenTileFactoryInfo;
import ws.palladian.nodes.extraction.location.tiles.WikimediaMaps;
import ws.palladian.nodes.extraction.location.waypointrenderer.CircleWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.DropWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.InfoWaypointRenderer;
import ws.palladian.nodes.extraction.location.waypointrenderer.LabelWaypointRenderer;

class MapViewer2NodeSettings {
    private static final InfoWaypointRenderer DEFAULT_RENDERER = new DropWaypointRenderer();
    private static final TileFactoryInfo DEFAULT_TILE_FACTORY = new OSMTileFactoryInfo();
    static final Set<InfoWaypointRenderer> RENDERERS = new LinkedHashSet<InfoWaypointRenderer>();
    static final List<TileFactoryInfo> TILE_FACTORIES = new ArrayList<TileFactoryInfo>();
    private static final String CFGKEY_INPUT_COORDINATE_NAME = "settingCoordinateInputColumn";
    private static final String CFGKEY_INPUT_LABEL = "settingLabelInputColumn";
    final SettingsModelString inputColumn = new SettingsModelString("settingCoordinateInputColumn", null);
    final SettingsModelString labelColumn = new SettingsModelString("settingLabelInputColumn", null);
    final SettingsModelString renderer = new SettingsModelString("renderer", DEFAULT_RENDERER.getName());
    final SettingsModelString tileProvider = new SettingsModelString("tileProvider", DEFAULT_TILE_FACTORY.getName());
    final SettingsModelIntegerBounded width = new SettingsModelIntegerBounded("width", 500, 50, 5000);
    final SettingsModelIntegerBounded height = new SettingsModelIntegerBounded("height", 500, 50, 5000);

    static {
        RENDERERS.add(DEFAULT_RENDERER);
        RENDERERS.add(new LabelWaypointRenderer());
        RENDERERS.add(new CircleWaypointRenderer());
        TILE_FACTORIES.add(DEFAULT_TILE_FACTORY);
        TILE_FACTORIES.add(AppleTileFactoryInfo.APPLE);
        TILE_FACTORIES.add((TileFactoryInfo)new ws.palladian.nodes.extraction.location.tiles.VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.MAP));
        TILE_FACTORIES.add((TileFactoryInfo)new ws.palladian.nodes.extraction.location.tiles.VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.SATELLITE));
        TILE_FACTORIES.add((TileFactoryInfo)new ws.palladian.nodes.extraction.location.tiles.VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID));
        TILE_FACTORIES.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.TONER));
        TILE_FACTORIES.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.TERRAIN));
        TILE_FACTORIES.add(new StamenTileFactoryInfo(StamenTileFactoryInfo.Type.WATERCOLOR));
        TILE_FACTORIES.add(WikimediaMaps.INSTANCE);
        Collections.sort(TILE_FACTORIES, Comparator.comparing(TileFactoryInfo::getName));
    }

    MapViewer2NodeSettings() {
    }

    void saveSettings(NodeSettingsWO settings) {
        this.inputColumn.saveSettingsTo(settings);
        this.labelColumn.saveSettingsTo(settings);
        this.renderer.saveSettingsTo(settings);
        this.tileProvider.saveSettingsTo(settings);
        this.width.saveSettingsTo(settings);
        this.height.saveSettingsTo(settings);
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.loadSettingsFrom(settings);
        this.labelColumn.loadSettingsFrom(settings);
        this.renderer.loadSettingsFrom(settings);
        this.tileProvider.loadSettingsFrom(settings);
        this.width.loadSettingsFrom(settings);
        this.height.loadSettingsFrom(settings);
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.validateSettings(settings);
        this.labelColumn.validateSettings(settings);
        this.renderer.validateSettings(settings);
        this.tileProvider.validateSettings(settings);
        this.width.validateSettings(settings);
        this.height.validateSettings(settings);
    }

    TileFactoryInfo getTileFactoryInfo() {
        return TILE_FACTORIES.stream().filter(f -> f.getName().equals(this.tileProvider.getStringValue())).findFirst().orElse(DEFAULT_TILE_FACTORY);
    }

    InfoWaypointRenderer getRenderer() {
        return RENDERERS.stream().filter(r -> r.getName().equals(this.renderer.getStringValue())).findFirst().orElse(DEFAULT_RENDERER);
    }
}

