/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.aggregation;

import java.awt.Component;
import org.knime.base.data.aggregation.AggregationOperator;
import org.knime.base.data.aggregation.GlobalSettings;
import org.knime.base.data.aggregation.OperatorColumnSettings;
import org.knime.base.data.aggregation.OperatorData;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelDouble;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.port.PortObjectSpec;
import ws.palladian.helper.math.FatStats;
import ws.palladian.helper.math.Stats;

public class EmpiricalDistributionOperator
extends AggregationOperator {
    private final SettingsModelDouble tModel = new SettingsModelDouble("t", 0.0);
    private Stats stats = new FatStats();
    private DialogComponent dialogComponent;

    public EmpiricalDistributionOperator() {
        this(GlobalSettings.DEFAULT, OperatorColumnSettings.DEFAULT_EXCL_MISSING);
    }

    private EmpiricalDistributionOperator(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        super(new OperatorData("Empirical Distribution", true, false, DoubleValue.class, false), globalSettings, opColSettings);
    }

    public String getDescription() {
        return "Calculate fraction of observations using the empirical distribution function.";
    }

    public String getDetailedDescription() {
        return "Applies the empirical distribution function (aka. empirical Cumulative Distribution Function, eCDF) to calculate the fraction of observations of the measured variable that are less than or equal the specified value.<br><br><b>Example:</b> For the observations <tt>[7, 9, 10, 18, 6]</tt>, and a value <tt>t=9</tt>, the probability would be <tt>3/5 = 0.6</tt>.<br><br>More details see <a href=\"https://en.wikipedia.org/wiki/Empirical_distribution_function\">here</a>.";
    }

    public AggregationOperator createInstance(GlobalSettings globalSettings, OperatorColumnSettings opColSettings) {
        EmpiricalDistributionOperator op = new EmpiricalDistributionOperator(globalSettings, opColSettings);
        op.tModel.setDoubleValue(this.tModel.getDoubleValue());
        return op;
    }

    protected boolean computeInternal(DataCell cell) {
        this.stats.add((Number)((DoubleValue)cell).getDoubleValue());
        return false;
    }

    protected DataType getDataType(DataType origType) {
        return DoubleCell.TYPE;
    }

    protected DataCell getResultInternal() {
        return new DoubleCell(this.stats.getCumulativeProbability(this.tModel.getDoubleValue()));
    }

    protected void resetInternal() {
        this.stats = new FatStats();
    }

    public boolean hasOptionalSettings() {
        return true;
    }

    public Component getSettingsPanel() {
        return this.getDC().getComponentPanel();
    }

    private DialogComponent getDC() {
        if (this.dialogComponent == null) {
            this.dialogComponent = new DialogComponentNumber((SettingsModelNumber)this.tModel, "t", (Number)1);
        }
        return this.dialogComponent;
    }

    public void loadSettingsFrom(NodeSettingsRO settings, DataTableSpec spec) throws NotConfigurableException {
        this.getDC().loadSettingsFrom(settings, (PortObjectSpec[])new DataTableSpec[]{spec});
    }

    public void loadValidatedSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.tModel.loadSettingsFrom(settings);
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.tModel.saveSettingsTo(settings);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.tModel.validateSettings(settings);
    }

    public String getColumnLabel() {
        return "empirical-distribution-t=" + this.tModel.getDoubleValue();
    }
}

