/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.dist;

import java.util.Set;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.distance.DistanceMeasure;
import org.knime.distance.DistanceMeasurePortObject;
import org.knime.distance.DistanceMeasurePortSpec;
import org.knime.distance.DistanceMeasurementException;
import ws.palladian.nodes.PalladianPluginActivator;

final class ColumnDistanceNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final int DATA_TABLE_IDX = 0;
    private static final int DISTANCE_PORT_1_IDX = 1;
    private static final int DISTANCE_PORT_2_IDX = 2;
    private DistanceMeasurePortObject dist1;
    private DistanceMeasurePortObject dist2;

    protected ColumnDistanceNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, DistanceMeasurePortObject.TYPE, DistanceMeasurePortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE}, 0, 0);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable dataTable = (BufferedDataTable)inObjects[0];
        DataTableSpec dataTableSpec = dataTable.getSpec();
        this.dist1 = (DistanceMeasurePortObject)inObjects[1];
        this.dist2 = (DistanceMeasurePortObject)inObjects[2];
        ColumnRearranger columnRearranger = this.createColumnRearranger(dataTableSpec);
        BufferedDataTable resultTable = exec.createColumnRearrangeTable(dataTable, columnRearranger, (ExecutionMonitor)exec);
        return new PortObject[]{resultTable};
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        final DistanceMeasure measure = this.dist1.createDistanceMeasure(dataTableSpec, null);
        String inputCol1 = ColumnDistanceNodeModel.getFirst(this.dist1.getSpec().getColumnNames());
        String inputCol2 = ColumnDistanceNodeModel.getFirst(this.dist2.getSpec().getColumnNames());
        final int inputIdx1 = dataTableSpec.findColumnIndex(inputCol1);
        final int inputIdx2 = dataTableSpec.findColumnIndex(inputCol2);
        DataColumnSpec outSpec = ColumnDistanceNodeModel.createAppendedColumnSpec(this.dist1.getSpec(), this.dist2.getSpec());
        SingleCellFactory factory = new SingleCellFactory(true, outSpec){

            public DataCell getCell(DataRow row) {
                double distance;
                DataCell[] cellArray = new DataCell[row.getNumCells()];
                int i = 0;
                while (i < row.getNumCells()) {
                    cellArray[i] = row.getCell(i);
                    ++i;
                }
                cellArray[inputIdx1] = cellArray[inputIdx2];
                DefaultRow simulatedRow = new DefaultRow(row.getKey(), cellArray);
                try {
                    distance = measure.computeDistance(row, (DataRow)simulatedRow);
                }
                catch (DistanceMeasurementException e) {
                    return new MissingCell(e.getMessage());
                }
                return new DoubleCell(distance);
            }

            public void afterProcessing() {
                ColumnDistanceNodeModel.this.dist1 = null;
                ColumnDistanceNodeModel.this.dist2 = null;
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(dataTableSpec);
        columnRearranger.append((CellFactory)factory);
        return columnRearranger;
    }

    private static String getFirst(Set<String> set) {
        return (String)set.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Set was empty"));
    }

    private static DataColumnSpec createAppendedColumnSpec(DistanceMeasurePortSpec distSpec1, DistanceMeasurePortSpec distSpec2) {
        String inputCol1 = ColumnDistanceNodeModel.getFirst(distSpec1.getColumnNames());
        String inputCol2 = ColumnDistanceNodeModel.getFirst(distSpec2.getColumnNames());
        return new DataColumnSpecCreator("distance (" + inputCol1 + ", " + inputCol2 + ")", DoubleCell.TYPE).createSpec();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inTableSpec = (DataTableSpec)inSpecs[0];
        DistanceMeasurePortSpec dist1Spec = (DistanceMeasurePortSpec)inSpecs[1];
        DistanceMeasurePortSpec dist2Spec = (DistanceMeasurePortSpec)inSpecs[2];
        dist1Spec.validate(inTableSpec);
        dist2Spec.validate(inTableSpec);
        if (!dist1Spec.getFactoryId().equals(dist2Spec.getFactoryId())) {
            throw new InvalidSettingsException("Different distance factories: " + dist1Spec.getFactoryId() + " vs. " + dist2Spec.getFactoryId() + ".");
        }
        if (dist1Spec.getColumnNames().size() != 1 || dist2Spec.getColumnNames().size() != 1) {
            throw new InvalidSettingsException("This node only works for distance measures with one input column.");
        }
        DataTableSpec outTableSpec = new DataTableSpecCreator(inTableSpec).addColumns(new DataColumnSpec[]{ColumnDistanceNodeModel.createAppendedColumnSpec(dist1Spec, dist2Spec)}).createSpec();
        return new PortObjectSpec[]{outTableSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }
}

