/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.hash2;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathConstants;
import org.apache.xmlbeans.XmlException;
import org.knime.core.node.DelegateNodeDescription;
import org.knime.core.node.NodeDescription;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ws.palladian.nodes.DefaultNodeFactory;
import ws.palladian.nodes.XPathUtils;
import ws.palladian.nodes.helper.hash2.HashAlgorithm;
import ws.palladian.nodes.helper.hash2.HashAlgorithms;
import ws.palladian.nodes.helper.hash2.HashCalculator2NodeDialog;
import ws.palladian.nodes.helper.hash2.HashCalculator2NodeModel;

public class HashCalculator2NodeFactory
extends DefaultNodeFactory<HashCalculator2NodeModel> {
    public HashCalculator2NodeModel createNodeModel() {
        return new HashCalculator2NodeModel();
    }

    @Override
    public boolean hasDialog() {
        return true;
    }

    @Override
    public NodeDialogPane createNodeDialogPane() {
        return new HashCalculator2NodeDialog();
    }

    protected NodeDescription createNodeDescription() throws SAXException, IOException, XmlException {
        NodeDescription description = super.createNodeDescription();
        final Element xmlDescription = description.getXMLDescription();
        HashCalculator2NodeFactory.augmentXmlDescription(xmlDescription);
        return new DelegateNodeDescription(description){

            public Element getXMLDescription() {
                return xmlDescription;
            }
        };
    }

    private static void augmentXmlDescription(Element xmlDescription) {
        Set extensionHashAlgorithms;
        Document d = xmlDescription.getOwnerDocument();
        Node placeholder = (Node)XPathUtils.xPath(d, "//*[normalize-space() = 'PLACEHOLDER']", XPathConstants.NODE);
        if (placeholder == null) {
            NodeLogger.getLogger(HashCalculator2NodeFactory.class).coding((Object)"PLACEHOLDER element is missing -- cannot insert dynamic parts into description.");
        }
        if (!(extensionHashAlgorithms = HashAlgorithms.getAll().stream().filter(algo -> !algo.getProvider().equalsIgnoreCase("SUN")).collect(Collectors.groupingBy(HashAlgorithm::getProvider, Collectors.toList())).entrySet()).isEmpty()) {
            Element p = d.createElement("p");
            p.appendChild(d.createTextNode("Additionally, the following hashing algorithms are provided via an extension point:"));
            placeholder.getParentNode().insertBefore(p, placeholder);
            Element ul = d.createElement("ul");
            extensionHashAlgorithms.stream().forEach(e -> {
                Element li = d.createElement("li");
                Element b = d.createElement("b");
                b.appendChild(d.createTextNode((String)e.getKey()));
                li.appendChild(b);
                ul.appendChild(li);
                Element algoUl = d.createElement("ul");
                li.appendChild(algoUl);
                ((List)e.getValue()).stream().sorted(Comparator.comparing(HashAlgorithm::getIdentifier)).forEach(algo -> {
                    Element algoLi = d.createElement("li");
                    algoLi.appendChild(d.createTextNode(algo.getIdentifier()));
                    algoUl.appendChild(algoLi);
                });
            });
            placeholder.getParentNode().insertBefore(ul, placeholder);
        }
        placeholder.getParentNode().removeChild(placeholder);
    }
}

