/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.math;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.math.RMSECalculatorNodeDialog;

@Deprecated
public class RMSECalculatorNodeModel
extends NodeModel {
    static final String CFGKEY_REAL_COLUMN_NAME = "realColumnName";
    static final String CFGKEY_PREDICTED_COLUMN_NAME = "predictedColumnName";
    private final SettingsModelString settingsRealColumn = RMSECalculatorNodeDialog.createSettingsRealColumn();
    private final SettingsModelString settingsPredictedColumn = RMSECalculatorNodeDialog.createSettingsPredictedColumn();

    protected RMSECalculatorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        double sum = 0.0;
        BufferedDataTable table = inData[0];
        int rowCount = table.getRowCount();
        int currentRow = 0;
        DataTableSpec inSpec = inData[0].getSpec();
        int realIndex = inSpec.findColumnIndex(this.settingsRealColumn.getStringValue());
        int predictedIndex = inSpec.findColumnIndex(this.settingsPredictedColumn.getStringValue());
        for (DataRow row : table) {
            exec.checkCanceled();
            exec.setProgress((double)currentRow / (double)rowCount, "processing row " + currentRow++);
            double real = ((DoubleValue)row.getCell(realIndex)).getDoubleValue();
            double predicted = ((DoubleValue)row.getCell(predictedIndex)).getDoubleValue();
            sum += Math.pow(real - predicted, 2.0);
        }
        double rmse = Math.sqrt(sum / (double)currentRow);
        DataTableSpec outputSpec = this.createOutputSpec();
        BufferedDataContainer buf = exec.createDataContainer(outputSpec);
        DataCell[] cells = new DataCell[]{new DoubleCell(rmse)};
        buf.addRowToTable((DataRow)new DefaultRow("RMSE", cells));
        buf.close();
        return new BufferedDataTable[]{buf.getTable()};
    }

    private DataTableSpec createOutputSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("RMSE", DoubleCell.TYPE).createSpec()};
        return new DataTableSpec(allColSpecs);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String columnName;
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec realColSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingsRealColumn.getStringValue(), DoubleValue.class);
        DataColumnSpec predictedColSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingsPredictedColumn.getStringValue(), DoubleValue.class);
        if (realColSpec == null) {
            realColSpec = PalladianKnimeHelper.guessColumn(inSpec, DoubleValue.class);
            columnName = realColSpec.getName();
            this.setWarningMessage("Guessing input column for real value: " + columnName);
            this.settingsRealColumn.setStringValue(columnName);
        }
        if (predictedColSpec == null) {
            int i = 0;
            while (i < inSpec.getNumColumns()) {
                DataColumnSpec columnSpec = inSpec.getColumnSpec(i);
                if (columnSpec.getType().isCompatible(DoubleValue.class) && !columnSpec.getName().equals(this.settingsRealColumn.getStringValue())) {
                    predictedColSpec = columnSpec;
                    break;
                }
                ++i;
            }
        }
        if (predictedColSpec == null) {
            throw new InvalidSettingsException("No suitable column for predicted value found.");
        }
        columnName = predictedColSpec.getName();
        this.setWarningMessage("Guessing input column for predicted value: " + columnName);
        this.settingsPredictedColumn.setStringValue(columnName);
        return new DataTableSpec[]{this.createOutputSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsRealColumn.saveSettingsTo(settings);
        this.settingsPredictedColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsRealColumn.loadSettingsFrom(settings);
        this.settingsPredictedColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsRealColumn.validateSettings(settings);
        this.settingsPredictedColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

