/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.StringValue;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.util.ColumnFilter;

public class ThresholdAnalyzerNodeDialog
extends DefaultNodeSettingsPane {
    private static final NodeLogger logger = NodeLogger.getLogger(ThresholdAnalyzerNodeDialog.class);
    private DataTableSpec inSpec;
    private final DialogComponentStringSelection valueSelection;
    private final SettingsModelString settingsModelColumnName = ThresholdAnalyzerNodeDialog.createSettingsModelClassColumn();
    private final SettingsModelString settingsModelClassValue;
    private final SettingsModelString settingsModelProbabilityColumn;

    protected ThresholdAnalyzerNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settingsModelColumnName, "Class column", 0, (ColumnFilter)new ClassColumnFilter()));
        this.settingsModelClassValue = ThresholdAnalyzerNodeDialog.createSettingsModelClassValue();
        this.valueSelection = new DialogComponentStringSelection(this.settingsModelClassValue, "Positive class value", new String[]{""});
        this.addDialogComponent((DialogComponent)this.valueSelection);
        this.settingsModelProbabilityColumn = ThresholdAnalyzerNodeDialog.createSettingsModelProbColumn();
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settingsModelProbabilityColumn, "Positive class probability", 0, new Class[]{DoubleValue.class}));
        this.settingsModelColumnName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ThresholdAnalyzerNodeDialog.this.inSpec != null) {
                    ThresholdAnalyzerNodeDialog.this.updateValueSelection();
                }
            }
        });
        this.settingsModelClassValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThresholdAnalyzerNodeDialog.this.updateProbabilitySelection();
            }
        });
    }

    static SettingsModelString createSettingsModelClassValue() {
        return new SettingsModelString("positiveClassValue", null);
    }

    static SettingsModelString createSettingsModelProbColumn() {
        return new SettingsModelString("probabilityColumn", null);
    }

    static SettingsModelString createSettingsModelClassColumn() {
        return new SettingsModelString("classColumn", null);
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, DataTableSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        if (specs[0] == null) {
            throw new NotConfigurableException("Necessary DataTabelSpec for input is missing, cannot configure.");
        }
        this.inSpec = specs[0];
        this.updateValueSelection();
        this.updateProbabilitySelection();
    }

    private void updateProbabilitySelection() {
        if (this.inSpec == null) {
            return;
        }
        String classValue = this.settingsModelClassValue.getStringValue();
        if (Arrays.asList(this.inSpec.getColumnNames()).contains(classValue)) {
            logger.debug((Object)("auto-setting probability column to " + classValue));
            this.settingsModelProbabilityColumn.setStringValue(classValue);
        } else {
            logger.debug((Object)("no auto-setting for probability column (" + classValue + " not found as column)"));
        }
    }

    private void updateValueSelection() {
        String selCol = this.settingsModelColumnName.getStringValue();
        int selIndex = this.inSpec.findColumnIndex(selCol);
        Set values = this.inSpec.getColumnSpec(selIndex).getDomain().getValues();
        ArrayList<String> newItems = new ArrayList<String>();
        for (DataCell cell : values) {
            newItems.add(((StringValue)cell).getStringValue());
        }
        this.valueSelection.replaceListItems(newItems, null);
    }

    private static final class ClassColumnFilter
    implements ColumnFilter {
        private ClassColumnFilter() {
        }

        public boolean includeColumn(DataColumnSpec colSpec) {
            Set values;
            return colSpec.getType().isCompatible(StringValue.class) && (values = colSpec.getDomain().getValues()) != null && values.size() == 2;
        }

        public String allFilteredMsg() {
            return "No suitable columns for class values found, required is a cell containing Strings with two different possible values.";
        }
    }
}

