/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.math;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.DecimalFormat;
import org.knime.base.node.util.DataArray;
import org.knime.base.node.viz.plotter.AbstractPlotter;
import org.knime.base.node.viz.plotter.DataProvider;
import org.knime.base.node.viz.plotter.basic.BasicDrawingPane;
import org.knime.base.node.viz.plotter.basic.BasicPlotter;
import org.knime.base.node.viz.plotter.basic.BasicPlotterImpl;
import org.knime.core.data.DataRow;
import org.knime.core.data.DoubleValue;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeView;
import ws.palladian.nodes.helper.math.ThresholdAnalyzerNodeModel;

public class ThresholdAnalyzerNodeView
extends NodeView<ThresholdAnalyzerNodeModel> {
    private static final Color PR_COLOR = Color.GREEN;
    private static final Color RC_COLOR = Color.ORANGE;
    private static final Color F1_COLOR = Color.BLUE;
    private static final Color ACCURACY_COLOR = Color.RED;
    private final BasicPlotter plotter;

    protected ThresholdAnalyzerNodeView(ThresholdAnalyzerNodeModel nodeModel) {
        super((NodeModel)nodeModel);
        BasicDrawingPane drawingPane = new BasicDrawingPane(){
            private static final long serialVersionUID = 1L;

            public synchronized void paintContent(Graphics g) {
                super.paintContent(g);
                int height = g.getFontMetrics().getHeight();
                g.setColor(PR_COLOR);
                g.drawString("Precision", 3, this.getHeight() - 3 * height - 3);
                g.setColor(RC_COLOR);
                g.drawString("Recall", 3, this.getHeight() - 2 * height - 3);
                g.setColor(F1_COLOR);
                g.drawString("F1 " + ThresholdAnalyzerNodeView.this.getMaxF1(), 3, this.getHeight() - height - 3);
                if (ThresholdAnalyzerNodeView.this.getNodeModel() != null && ((ThresholdAnalyzerNodeModel)ThresholdAnalyzerNodeView.this.getNodeModel()).getDataArray(0) != null) {
                    boolean hasAccuracy;
                    DataArray data = ((DataProvider)ThresholdAnalyzerNodeView.this.getNodeModel()).getDataArray(0);
                    boolean bl = hasAccuracy = data.getDataTableSpec().getNumColumns() > 3;
                    if (hasAccuracy) {
                        g.setColor(ACCURACY_COLOR);
                        g.drawString("Accuracy", 3, this.getHeight() - 3);
                    }
                }
            }
        };
        this.plotter = new BasicPlotterImpl(drawingPane){
            private static final long serialVersionUID = 1L;
            {
                this.removeMouseListener(AbstractPlotter.SelectionMouseListener.class);
            }

            public void updatePaintModel() {
                super.updatePaintModel();
                this.reset();
                if (ThresholdAnalyzerNodeView.this.getNodeModel() != null && ((ThresholdAnalyzerNodeModel)ThresholdAnalyzerNodeView.this.getNodeModel()).getDataArray(0) != null) {
                    DataArray data = ((DataProvider)ThresholdAnalyzerNodeView.this.getNodeModel()).getDataArray(0);
                    BasicStroke stroke = new BasicStroke(2.0f);
                    this.addLine(data, 0, 1, PR_COLOR, stroke);
                    this.addLine(data, 0, 2, RC_COLOR, stroke);
                    this.addLine(data, 0, 3, F1_COLOR, stroke);
                    if (data.getDataTableSpec().getNumColumns() > 3) {
                        this.addLine(data, 0, 4, ACCURACY_COLOR, stroke);
                    }
                }
            }
        };
        this.setComponent((Component)this.plotter);
    }

    private String getMaxF1() {
        if (this.getNodeModel() != null && ((ThresholdAnalyzerNodeModel)this.getNodeModel()).getDataArray(0) != null) {
            DataArray data = ((ThresholdAnalyzerNodeModel)this.getNodeModel()).getDataArray(0);
            double maxFOne = Double.MIN_VALUE;
            double atThreshold = Double.MIN_VALUE;
            for (DataRow row : data) {
                double fOne = ((DoubleValue)row.getCell(3)).getDoubleValue();
                if (!(fOne > maxFOne)) continue;
                maxFOne = fOne;
                atThreshold = ((DoubleValue)row.getCell(0)).getDoubleValue();
            }
            DecimalFormat format = new DecimalFormat("#0.000");
            return "(max = " + format.format(maxFOne) + " at " + atThreshold + ")";
        }
        return "???";
    }

    protected void modelChanged() {
        if (this.getNodeModel() != null && ((ThresholdAnalyzerNodeModel)this.getNodeModel()).getDataArray(0) != null) {
            this.plotter.updatePaintModel();
            this.plotter.fitToScreen();
        }
    }

    protected void onClose() {
    }

    protected void onOpen() {
    }
}

