/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.nlp.dist.jarowinkler;

import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import ws.palladian.helper.functional.Distance;
import ws.palladian.helper.nlp.JaroWinklerSimilarity;
import ws.palladian.nodes.helper.nlp.dist.jarowinkler.JaroWinklerDistanceConfig;

public final class JaroWinklerDistance
extends SingleColumnDistanceMeasure<JaroWinklerDistanceConfig> {
    private static final Distance<String> JARO_WINKLER = new JaroWinklerSimilarity();

    JaroWinklerDistance(JaroWinklerDistanceConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        StringValue value1 = (StringValue)this.checkNotMissing(row1, this.getIndex(), StringValue.class);
        StringValue value2 = (StringValue)this.checkNotMissing(row2, this.getIndex(), StringValue.class);
        return JARO_WINKLER.getDistance((Object)value1.getStringValue(), (Object)value2.getStringValue());
    }
}

