/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.nlp.dist.tfidf;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.IntValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.classification.text.FeatureSetting;
import ws.palladian.extraction.feature.MapTermCorpus;
import ws.palladian.extraction.feature.TermCorpus;
import ws.palladian.extraction.text.similarity.TfIdfSimilarity;
import ws.palladian.helper.collection.Bag;
import ws.palladian.helper.nlp.StringMetric;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.nlp.dist.tfidf.TfIdfSimilarityNodeSettings;

public class TfIdfSimilarityNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final int FREQUENCIES_TABLE = 0;
    private static final int TEXT_TABLE = 1;
    private final TfIdfSimilarityNodeSettings nodeSettings = new TfIdfSimilarityNodeSettings();
    private TermCorpus termCorpus;

    protected TfIdfSimilarityNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE}, 1, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        ExecutionMonitor readProgress = exec.createSubProgress(0.5);
        Bag counts = new Bag();
        int numDocuments = 0;
        int rowCount = 0;
        for (DataRow row : inData[0]) {
            String term = ((StringValue)row.getCell(0)).getStringValue();
            int count = ((IntValue)row.getCell(1)).getIntValue();
            if (term.equals("#DOCS")) {
                numDocuments = count;
            } else {
                counts.add((Object)term, count);
            }
            readProgress.setProgress((double)((float)(++rowCount) / (float)inData[0].size()), () -> "Read row '" + String.valueOf(row.getKey()) + "'");
        }
        this.termCorpus = new MapTermCorpus(counts, numDocuments);
        ColumnRearranger rearranger = this.createColumnRearranger(inData[1].getSpec());
        BufferedDataTable table = exec.createColumnRearrangeTable(inData[1], rearranger, (ExecutionMonitor)exec.createSubExecutionContext(0.5));
        return new BufferedDataTable[]{table};
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        FeatureSetting featureSetting = this.nodeSettings.featureConfig.getFeatureSetting();
        TfIdfSimilarity similarity = new TfIdfSimilarity(featureSetting, this.termCorpus, this.nodeSettings.binarizeTermCount.getBooleanValue());
        final int value1idx = spec.findColumnIndex(this.nodeSettings.string1Column.getStringValue());
        final int value2idx = spec.findColumnIndex(this.nodeSettings.string2Column.getStringValue());
        SingleCellFactory cellFactory = new SingleCellFactory(true, this.createAppendedColumnSpec(), (StringMetric)similarity){
            private final /* synthetic */ StringMetric val$similarity;
            {
                this.val$similarity = stringMetric;
                super($anonymous0, $anonymous1);
            }

            public DataCell getCell(DataRow row) {
                if (row.getCell(value1idx).isMissing() || row.getCell(value2idx).isMissing()) {
                    return DataType.getMissingCell();
                }
                String value1 = ((StringValue)row.getCell(value1idx)).getStringValue();
                String value2 = ((StringValue)row.getCell(value2idx)).getStringValue();
                return new DoubleCell(this.val$similarity.getSimilarity((Object)value1, (Object)value2));
            }

            public void afterProcessing() {
                TfIdfSimilarityNodeModel.this.termCorpus = null;
            }
        };
        cellFactory.setParallelProcessing(true);
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }

    private DataColumnSpec createAppendedColumnSpec() {
        String appendedColumnName = "tfIdfSim(" + this.nodeSettings.string1Column.getStringValue() + "," + this.nodeSettings.string2Column.getStringValue() + ")";
        return new DataColumnSpecCreator(appendedColumnName, DoubleCell.TYPE).createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{new DataTableSpecCreator(inSpecs[1]).addColumns(new DataColumnSpec[]{this.createAppendedColumnSpec()}).createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

