/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.imageprocessing.trim;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.image.png.PNGImageContent;
import org.knime.core.data.image.png.PNGImageValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.imageprocessing.trim.ImageTrimmer;
import ws.palladian.nodes.imageprocessing.trim.TrimImageNodeSettings;

class TrimImageNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final TrimImageNodeSettings nodeSettings = new TrimImageNodeSettings();

    TrimImageNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        String inputColName = this.nodeSettings.settingInputColumnName.getStringValue();
        final int inputColIdx = inSpec.findColumnIndex(inputColName);
        DataColumnSpec spec = new DataColumnSpecCreator(inputColName + " trimmed", PNGImageContent.TYPE).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(true, spec){

            public DataCell getCell(DataRow row) {
                DataCell cell = row.getCell(inputColIdx);
                if (cell.isMissing()) {
                    return DataType.getMissingCell();
                }
                PNGImageValue pngValue = (PNGImageValue)cell;
                try {
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(pngValue.getImageContent().getByteArrayReference()));
                    BufferedImage trimmedImage = ImageTrimmer.trimImage(bufferedImage);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)trimmedImage, "png", (OutputStream)outputStream);
                    return new PNGImageContent(outputStream.toByteArray()).toImageCell();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(inSpec);
        columnRearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.settingRemoveInputColumn.getBooleanValue()) {
            columnRearranger.remove(new int[]{inputColIdx});
        }
        return columnRearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettings(settings);
    }
}

