/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.preprocessing.scraping.htmltotext;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.xml.XMLValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.w3c.dom.Node;
import ws.palladian.helper.html.HtmlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.preprocessing.scraping.htmltotext.HtmlNodeToTextNodeDialog;

public class HtmlNodeToTextNodeModel
extends SimpleStreamableFunctionNodeModel {
    public static final String CFGKEY_INPUT_COLUMN_NAME = "settingInputColumn";
    private final SettingsModelString settingInputColumn = HtmlNodeToTextNodeDialog.createSettingsInputColumn();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        String appendedColumnName = DataTableSpec.getUniqueColumnName((DataTableSpec)spec, (String)(this.settingInputColumn.getStringValue() + ": Readable Text"));
        final int inputIndex = spec.findColumnIndex(this.settingInputColumn.getStringValue());
        SingleCellFactory cellFactory = new SingleCellFactory(true, new DataColumnSpecCreator(appendedColumnName, StringCell.TYPE).createSpec()){

            public DataCell getCell(DataRow row) {
                DataCell inputCell = row.getCell(inputIndex);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                XMLValue xmlValue = (XMLValue)inputCell;
                String readableText = HtmlHelper.documentToReadableText((Node)xmlValue.getDocument());
                return new StringCell(readableText);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpecs[0], this.settingInputColumn.getStringValue(), XMLValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpecs[0], XMLValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
    }
}

