/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.knime.core.node.NodeLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import ws.palladian.nodes.retrieval.DefaultProxyProvider;
import ws.palladian.retrieval.HttpException;
import ws.palladian.retrieval.ImmutableProxy;
import ws.palladian.retrieval.Proxy;

public final class EclipseProxyProvider
extends DefaultProxyProvider {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(EclipseProxyProvider.class);
    public static final EclipseProxyProvider INSTANCE = new EclipseProxyProvider();
    private final ServiceTracker<IProxyService, IProxyService> proxyTracker;

    private EclipseProxyProvider() {
        BundleContext context = FrameworkUtil.getBundle(EclipseProxyProvider.class).getBundleContext();
        this.proxyTracker = new ServiceTracker(context, IProxyService.class, null);
        this.proxyTracker.open();
    }

    public Proxy getProxy(String url) throws HttpException {
        String host;
        IProxyData[] proxyData;
        IProxyService proxyService = (IProxyService)this.proxyTracker.getService();
        if (proxyService == null) {
            throw new IllegalStateException("Could not acquire proxy service");
        }
        try {
            proxyData = proxyService.select(new URI(url));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new HttpException("Invalid url " + url);
        }
        if (proxyData.length > 0 && (host = proxyData[0].getHost()) != null) {
            int port = proxyData[0].getPort();
            String userId = proxyData[0].getUserId();
            String password = proxyData[0].getPassword();
            if (userId != null) {
                LOGGER.debug((Object)("Using authenticated proxy: host=" + host + ":" + port + ", login=" + userId));
            } else {
                LOGGER.debug((Object)("Using proxy: host=" + host + ":" + port));
            }
            return new ImmutableProxy(host, port, userId, password);
        }
        LOGGER.debug((Object)"Using no proxy");
        return null;
    }
}

