/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpResultDataExtractorNodeDialog;
import ws.palladian.nodes.retrieval.HttpResultValue;
import ws.palladian.retrieval.HttpResult;

public class HttpResultDataExtractorNodeModel
extends NodeModel {
    static final String CFGKEY_INPUT_COLUMN_NAME = "inputColumn";
    static final String CFGKEY_APPEND_STATUS = "appendStatusInformation";
    static final String CFGKEY_APPEND_HEADERS = "appendHeaderInformation";
    static final String CFGKEY_BINARY_OUTPUT = "binaryOutput";
    static final String CFGKEY_LOCATIONS = "locations";
    private final SettingsModelString settingInputColumn = HttpResultDataExtractorNodeDialog.createSettingsInputColumn();
    private final SettingsModelBoolean settingStatusColumn = HttpResultDataExtractorNodeDialog.createSettingsStatusColumn();
    private final SettingsModelBoolean settingHeadersColumn = HttpResultDataExtractorNodeDialog.createSettingsHeadersColumns();
    private final SettingsModelBoolean settingBinaryResult = HttpResultDataExtractorNodeDialog.createSettingsModelBinary();
    private final SettingsModelBoolean settingLocations = HttpResultDataExtractorNodeDialog.createSettingsModelLocations();

    protected HttpResultDataExtractorNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = inData[0];
        DataTableSpec inSpec = inTable.getSpec();
        ColumnRearranger rearranger = this.createColumnRearranger(inSpec, inTable, exec);
        BufferedDataTable out = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec spec, BufferedDataTable table, ExecutionContext exec) {
        String columnName = this.settingInputColumn.getStringValue();
        int inputIdx = spec.findColumnIndex(columnName);
        if (inputIdx < 0) {
            throw new IllegalStateException("Invalid input index: " + inputIdx);
        }
        Set<String> headerNames = Collections.emptySet();
        if (this.settingHeadersColumn.getBooleanValue()) {
            headerNames = this.extractHeaderNames(table, inputIdx);
        }
        DataColumnSpec[] outSpec = this.createAppendedColumnSpec(headerNames);
        HttpResultToStringNodeFactory factory = new HttpResultToStringNodeFactory(outSpec, inputIdx, this.settingStatusColumn.getBooleanValue(), this.settingBinaryResult.getBooleanValue(), headerNames, this.settingLocations.getBooleanValue(), exec);
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    private Set<String> extractHeaderNames(BufferedDataTable table, int inputIdx) {
        TreeSet<String> headerNames = new TreeSet<String>();
        for (DataRow row : table) {
            DataCell cell = row.getCell(inputIdx);
            if (cell.isMissing()) continue;
            HttpResultValue value = (HttpResultValue)cell;
            Set names = value.getHttpResult().getHeaders().keySet();
            headerNames.addAll(names);
        }
        return headerNames;
    }

    private DataColumnSpec[] createAppendedColumnSpec(Set<String> headerNames) {
        ArrayList<DataColumnSpec> spec = new ArrayList<DataColumnSpec>();
        if (this.settingBinaryResult.getBooleanValue()) {
            spec.add(new DataColumnSpecCreator("Binary value", BinaryObjectDataCell.TYPE).createSpec());
        } else {
            spec.add(new DataColumnSpecCreator("String value", StringCell.TYPE).createSpec());
        }
        if (this.settingStatusColumn.getBooleanValue()) {
            spec.add(new DataColumnSpecCreator("Status code", IntCell.TYPE).createSpec());
        }
        if (headerNames != null) {
            for (String headerName : headerNames) {
                spec.add(new DataColumnSpecCreator(headerName, StringCell.TYPE).createSpec());
            }
        }
        if (this.settingLocations.getBooleanValue()) {
            spec.add(new DataColumnSpecCreator("Locations", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        }
        return spec.toArray(new DataColumnSpec[spec.size()]);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (this.settingHeadersColumn.getBooleanValue()) {
            return null;
        }
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), HttpResultValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, HttpResultValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        DataTableSpec appendedSpec = new DataTableSpec(this.createAppendedColumnSpec(null));
        DataTableSpec outSpec = new DataTableSpec(inSpec, appendedSpec);
        return new DataTableSpec[]{outSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
        this.settingStatusColumn.saveSettingsTo(settings);
        this.settingHeadersColumn.saveSettingsTo(settings);
        this.settingBinaryResult.saveSettingsTo(settings);
        this.settingLocations.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.settingStatusColumn);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.settingHeadersColumn);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.settingBinaryResult);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.settingLocations);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.settingStatusColumn);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.settingHeadersColumn);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.settingBinaryResult);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.settingLocations);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    private static final class HttpResultToStringNodeFactory
    extends AbstractCellFactory {
        private final int inputIdx;
        private final boolean status;
        private final Set<String> headerNames;
        private final BinaryObjectCellFactory binaryCellFactory;
        private final boolean locations;

        private HttpResultToStringNodeFactory(DataColumnSpec[] colSpec, int inputIdx, boolean status, boolean binaryOutput, Set<String> availableHeaders, boolean locations, ExecutionContext exec) {
            super(colSpec);
            this.inputIdx = inputIdx;
            this.status = status;
            this.headerNames = availableHeaders;
            this.binaryCellFactory = binaryOutput ? new BinaryObjectCellFactory(exec) : null;
            this.locations = locations;
        }

        public DataCell[] getCells(DataRow row) {
            DataCell cell = row.getCell(this.inputIdx);
            if (cell.isMissing()) {
                return this.createMissingCellRow();
            }
            if (!(cell instanceof HttpResultValue)) {
                throw new IllegalStateException("Invalid type, expected " + HttpResultValue.class.getName() + ", but got " + cell.getClass().getName());
            }
            ArrayList<Object> cells = new ArrayList<Object>();
            HttpResultValue httpResultValue = (HttpResultValue)cell;
            HttpResult httpResult = httpResultValue.getHttpResult();
            if (this.binaryCellFactory != null) {
                try {
                    cells.add(this.binaryCellFactory.create(httpResult.getContent()));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Exception while trying to create binary cell", e);
                }
            } else {
                cells.add(new StringCell(httpResult.getStringContent()));
            }
            if (this.status) {
                cells.add(new IntCell(httpResult.getStatusCode()));
            }
            for (String headerName : this.headerNames) {
                String headerValue = httpResult.getHeaderString(headerName);
                cells.add(headerValue != null ? new StringCell(headerValue) : DataType.getMissingCell());
            }
            if (this.locations) {
                List coll = httpResult.getLocations().stream().map(s -> new StringCell(s)).collect(Collectors.toList());
                cells.add(CollectionCellFactory.createListCell(coll));
            }
            return cells.toArray(new DataCell[cells.size()]);
        }

        private DataCell[] createMissingCellRow() {
            int count = 1 + (this.status ? 1 : 0) + this.headerNames.size();
            return Collections.nCopies(count, DataType.getMissingCell()).toArray(new DataCell[count]);
        }
    }
}

