/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.def.IntCell;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.util.filter.NameFilterConfiguration;
import ws.palladian.helper.constants.SizeUnit;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.DefaultProxyProvider;
import ws.palladian.nodes.retrieval.EclipseProxyProvider;
import ws.palladian.nodes.retrieval.HttpResultCell2;
import ws.palladian.nodes.retrieval.HttpResultCellFactory;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;
import ws.palladian.retrieval.CookieStore;
import ws.palladian.retrieval.HttpEntity;
import ws.palladian.retrieval.HttpException;
import ws.palladian.retrieval.HttpMethod;
import ws.palladian.retrieval.HttpRequest2Builder;
import ws.palladian.retrieval.HttpResult;
import ws.palladian.retrieval.HttpRetriever;
import ws.palladian.retrieval.HttpRetrieverFactory;
import ws.palladian.retrieval.ImmutableProxy;
import ws.palladian.retrieval.InputStreamHttpEntity;
import ws.palladian.retrieval.Proxy;
import ws.palladian.retrieval.ProxyProvider;
import ws.palladian.retrieval.StringHttpEntity;

class HttpRetrieverCellFactory
extends AbstractCellFactory {
    static final NodeLogger logger = NodeLogger.getLogger(HttpRetrieverCellFactory.class);
    private static final int MAX_WARNING_MESSAGES = 5;
    private final HttpRetrieverFactory retrieverFactory;
    private final HttpRetriever httpRetriever;
    private final int inputColumnIndex;
    private final boolean addStatusCode;
    private final int inputMethodColumnIndex;
    private final int inputEntityColumnIndex;
    private final String contentType;
    private final String[] includedHeaderCols;
    private final int[] includedHeaderIdxs;
    private final boolean failOnNonSuccessHttpStatusCode;
    private final boolean failOnNetworkError;
    private final List<String> warnings = new CopyOnWriteArrayList<String>();

    HttpRetrieverCellFactory(DataTableSpec inSpec, CookieStore cookieStore, HttpRetrieverNodeSettings settings) {
        super(HttpRetrieverCellFactory.createSpec(settings.addStatusCode.getBooleanValue()));
        int sizeLimit;
        if (inSpec == null) {
            throw new NullPointerException("inSpec was null");
        }
        int inputColumnIndex = inSpec.findColumnIndex(settings.urlColumnName.getStringValue());
        int inputMethodColumnIndex = inSpec.findColumnIndex(settings.methodColumnName.getStringValue());
        int inputEntityColumnIndex = inSpec.findColumnIndex(settings.entityColumnName.getStringValue());
        NameFilterConfiguration.FilterResult headerFilterResult = settings.headerColumns.applyTo(inSpec);
        Object[] includedHeaderCols = headerFilterResult.getIncludes();
        logger.debug((Object)("Adding header columns: " + Arrays.toString(includedHeaderCols)));
        if (inputColumnIndex < 0) {
            throw new IllegalArgumentException("inputColumnIndex must be greater/equal zero");
        }
        String contentType = settings.entityContentType.getStringValue();
        if (inputEntityColumnIndex >= 0 && contentType == null) {
            throw new IllegalArgumentException("inputEntityColumnIndex was greater/equal zero, but contentType was null");
        }
        int connectionTimeout = settings.connectionTimeout.getIntValue();
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("connectionTimeout must be greater/equal zero");
        }
        int socketTimeout = settings.socketTimeout.getIntValue();
        if (socketTimeout < 0) {
            throw new IllegalArgumentException("socketTimeout must be greater/equal zero");
        }
        String userAgent = settings.userAgent.getStringValue();
        if (userAgent == null) {
            throw new NullPointerException("userAgent must not be null");
        }
        this.inputColumnIndex = inputColumnIndex;
        this.addStatusCode = settings.addStatusCode.getBooleanValue();
        this.retrieverFactory = new HttpRetrieverFactory(settings.acceptAllCerts.getBooleanValue());
        HttpRetriever httpRetriever = this.retrieverFactory.create();
        httpRetriever.setNumRetries(settings.numRetries.getIntValue());
        httpRetriever.setConnectionTimeout(connectionTimeout);
        httpRetriever.setSocketTimeout(socketTimeout);
        httpRetriever.setUserAgent(userAgent);
        if (settings.useCustomProxy.getBooleanValue()) {
            final String proxyHost = settings.proxyHost.getStringValue();
            final int proxyPort = settings.proxyPort.getIntValue();
            final String proxyUsername = settings.proxyUsername.getStringValue();
            final String proxyPassword = settings.proxyPassword.getStringValue();
            httpRetriever.setProxyProvider((ProxyProvider)new DefaultProxyProvider(){

                public Proxy getProxy(String url) throws HttpException {
                    return new ImmutableProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
                }
            });
        } else {
            httpRetriever.setProxyProvider((ProxyProvider)EclipseProxyProvider.INSTANCE);
        }
        int n = sizeLimit = settings.sizeLimit.getBooleanValue() ? settings.maxSize.getIntValue() : -1;
        if (sizeLimit != -1) {
            long maxFileSizeBytes = SizeUnit.KILOBYTES.toBytes((long)sizeLimit);
            httpRetriever.setMaxFileSize(maxFileSizeBytes);
        }
        if (cookieStore != null) {
            httpRetriever.setCookieStore(cookieStore);
        }
        this.httpRetriever = httpRetriever;
        this.inputMethodColumnIndex = inputMethodColumnIndex;
        this.inputEntityColumnIndex = inputEntityColumnIndex;
        this.contentType = contentType;
        this.includedHeaderCols = includedHeaderCols != null ? includedHeaderCols : new String[]{};
        this.includedHeaderIdxs = PalladianKnimeHelper.findColumnIndices(inSpec, this.includedHeaderCols);
        this.failOnNonSuccessHttpStatusCode = settings.failOnNonSuccessStatusCode.getBooleanValue();
        this.failOnNetworkError = settings.failOnNetworkError.getBooleanValue();
        this.setParallelProcessing(true, 10, 50);
    }

    static DataColumnSpec[] createSpec(boolean addStatusCode) {
        ArrayList<DataColumnSpec> specs = new ArrayList<DataColumnSpec>();
        specs.add(new DataColumnSpecCreator("Result", HttpResultCell2.TYPE).createSpec());
        if (addStatusCode) {
            specs.add(new DataColumnSpecCreator("HTTP Status Code", IntCell.TYPE).createSpec());
        }
        return specs.toArray(new DataColumnSpec[0]);
    }

    public DataCell[] getCells(DataRow row) {
        DataCell entityCell;
        Object[] result = new DataCell[this.addStatusCode ? 2 : 1];
        Arrays.fill(result, DataType.getMissingCell());
        DataCell urlCell = row.getCell(this.inputColumnIndex);
        if (urlCell.isMissing()) {
            return result;
        }
        String url = PalladianKnimeHelper.getString(urlCell);
        if (!url.trim().equals(url)) {
            String msg = String.format("%s: Trimmed whitespace at URL beginning/end: '%s'", row.getKey(), url);
            this.warnings.add(msg);
            logger.warn((Object)msg);
            url = url.trim();
        }
        HttpMethod method = HttpMethod.GET;
        if (this.inputMethodColumnIndex != -1) {
            DataCell methodCell = row.getCell(this.inputMethodColumnIndex);
            if (methodCell.isMissing() || methodCell.toString().isEmpty()) {
                String message = String.format("%s: HTTP method is missing", row.getKey());
                logger.warn((Object)message);
                this.warnings.add(message);
                return result;
            }
            String methodString = PalladianKnimeHelper.getString(methodCell);
            try {
                method = HttpMethod.valueOf((String)methodString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String msg = String.format("%s: Unsupported HTTP method: %s", row.getKey(), methodString.toUpperCase());
                logger.warn((Object)msg);
                this.warnings.add(msg);
                return result;
            }
        } else {
            logger.debug((Object)"Assuming default GET method for all requests.");
        }
        HttpRequest2Builder builder = new HttpRequest2Builder(method, url);
        if (this.inputEntityColumnIndex != -1 && !(entityCell = row.getCell(this.inputEntityColumnIndex)).isMissing()) {
            if (entityCell instanceof BinaryObjectDataValue) {
                BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)entityCell;
                try {
                    builder.setEntity((HttpEntity)new InputStreamHttpEntity(binaryValue.openInputStream(), binaryValue.length(), this.contentType));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not open input stream for entity input in row " + String.valueOf(row.getKey()), e);
                }
            } else if (entityCell instanceof StringValue) {
                StringValue stringValue = (StringValue)entityCell;
                builder.setEntity((HttpEntity)new StringHttpEntity(stringValue.getStringValue(), this.contentType));
            } else {
                throw new IllegalArgumentException("Unsupported entity type: " + entityCell.getClass().getName());
            }
        }
        int i = 0;
        while (i < this.includedHeaderIdxs.length) {
            int colIdx = this.includedHeaderIdxs[i];
            DataCell cell = row.getCell(colIdx);
            if (!cell.isMissing()) {
                String key = this.includedHeaderCols[i];
                String value = ((StringValue)cell).getStringValue();
                builder.addHeader(key, value);
            }
            ++i;
        }
        try {
            HttpResult httpResult = this.httpRetriever.execute(builder.create());
            if (httpResult.errorStatus() && this.failOnNonSuccessHttpStatusCode) {
                throw new IllegalStateException("Encountered HTTP status " + httpResult.getStatusCode() + " in row " + String.valueOf(row.getKey()));
            }
            result[0] = HttpResultCellFactory.createCell(httpResult);
            if (this.addStatusCode) {
                result[1] = new IntCell(httpResult.getStatusCode());
            }
        }
        catch (HttpException e) {
            String msg = String.format("%s: Error retrieving %s: %s", row.getKey(), url, e.getMessage());
            if (this.failOnNetworkError) {
                throw new IllegalStateException(msg, e);
            }
            logger.warn((Object)msg, (Throwable)e);
            this.warnings.add(msg);
        }
        return result;
    }

    public final void afterProcessing() {
        this.retrieverFactory.close();
        if (!this.warnings.isEmpty()) {
            Object message = this.warnings.stream().sorted().limit(5L).collect(Collectors.joining("\n"));
            if (this.warnings.size() > 5) {
                message = (String)message + String.format("\n+ %s more", this.warnings.size() - 5);
            }
            this.setWarningMessageAfterProcessing((String)message);
        }
    }

    public void setWarningMessageAfterProcessing(String message) {
    }
}

