/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import org.knime.core.data.StringValue;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;

public class HttpRetrieverNodeDialog
extends DefaultNodeSettingsPane {
    private final HttpRetrieverNodeSettings httpRetrieverSettings = new HttpRetrieverNodeSettings();

    protected HttpRetrieverNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.httpRetrieverSettings.urlColumnName, "URL input", 0, new Class[]{StringValue.class}));
        DialogComponentBoolean sizeLimit = new DialogComponentBoolean(this.httpRetrieverSettings.sizeLimit, "Enable file size limitation");
        this.addDialogComponent((DialogComponent)sizeLimit);
        DialogComponentNumber maxSize = new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.maxSize, "Maximum file size (kB)", (Number)512);
        this.addDialogComponent((DialogComponent)maxSize);
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.addStatusCode, "Append column with HTTP status code"));
        this.createNewTab("Advanced");
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.numRetries, "# retries after error (for each URL)", (Number)1));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.connectionTimeout, "Connection timeout (ms)", (Number)1000, 6));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.socketTimeout, "Socket timeout (ms)", (Number)1000, 6));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.httpRetrieverSettings.userAgent, "User agent"));
    }
}

