/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.feeds.discovery;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.xml.XMLValue;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.w3c.dom.Document;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.retrieval.feeds.discovery.DiscoveredFeed;
import ws.palladian.retrieval.feeds.discovery.FeedDiscovery;

public class FeedDiscoveryNodeModel
extends NodeModel {
    static final String CFGKEY_DOCUMENT_COLUMN_NAME = "documentColumn";
    private final SettingsModelString settingColumnName = new SettingsModelString("documentColumn", null);

    protected FeedDiscoveryNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        DataTableSpec outputSpec = this.createOutputSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        long inRowCount = inData[0].size();
        long inRowIndex = 0L;
        long outRowIndex = 0L;
        int urlColumnIndex = inData[0].getSpec().findColumnIndex(this.settingColumnName.getStringValue());
        for (DataRow inRow : inData[0]) {
            DataCell inCell = inRow.getCell(urlColumnIndex);
            if (inCell.isMissing()) continue;
            Document document = ((XMLValue)inCell).getDocument();
            List discoveredFeeds = FeedDiscovery.discoverFeeds((Document)document);
            for (DiscoveredFeed discoveredFeed : discoveredFeeds) {
                RowKey key = RowKey.createRowKey((long)outRowIndex++);
                DataCell[] cells = new DataCell[]{FeedDiscoveryNodeModel.stringOrMissingCell(discoveredFeed.getFeedLink()), FeedDiscoveryNodeModel.stringOrMissingCell(discoveredFeed.getFeedType().name()), FeedDiscoveryNodeModel.stringOrMissingCell(discoveredFeed.getFeedTitle())};
                DefaultRow outRow = new DefaultRow(key, cells);
                container.addRowToTable((DataRow)outRow);
            }
            exec.checkCanceled();
            exec.setProgress((double)inRowIndex++ / (double)inRowCount, "Discovery for " + document.getDocumentURI());
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    private static DataCell stringOrMissingCell(String string) {
        if (string == null) {
            return DataType.getMissingCell();
        }
        return new StringCell(string);
    }

    private DataTableSpec createOutputSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("feed url", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("feed type", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("feed title", StringCell.TYPE).createSpec()};
        return new DataTableSpec(allColSpecs);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingColumnName.getStringValue(), XMLValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, XMLValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingColumnName.setStringValue(columnName);
        }
        return new DataTableSpec[]{this.createOutputSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingColumnName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

