/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.xml.XMLCell;
import org.knime.core.data.xml.XMLCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.util.FileUtil;
import org.knime.filehandling.core.connections.FSLocationSpec;
import org.knime.filehandling.core.connections.location.FSPathProvider;
import org.knime.filehandling.core.connections.location.FSPathProviderFactory;
import org.knime.filehandling.core.connections.uriexport.noconfig.NoConfigURIExporterFactory;
import org.knime.filehandling.core.data.location.FSLocationValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ws.palladian.helper.UrlHelper;
import ws.palladian.helper.html.HtmlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpResultValue;
import ws.palladian.nodes.retrieval.parser.HtmlParserNodeDialog;
import ws.palladian.nodes.retrieval.parser.HtmlParserNodeSettings;
import ws.palladian.persistence.ParserException;
import ws.palladian.retrieval.HttpResult;
import ws.palladian.retrieval.parser.DocumentParser;
import ws.palladian.retrieval.parser.ParserFactory;

public class HtmlParserNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(HtmlParserNodeModel.class);
    private final HtmlParserNodeSettings nodeSettings = new HtmlParserNodeSettings();
    private boolean httpUrlWarningShown = false;

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inputColumnIdx = spec.findColumnIndex(this.nodeSettings.columnName.getStringValue());
        final boolean makeAbsoluteUrls = this.nodeSettings.absoluteUrls.getBooleanValue();
        DataColumnSpec appendedSpec = new DataColumnSpecCreator("Document", XMLCell.TYPE).createSpec();
        SingleCellFactory factory = new SingleCellFactory(appendedSpec){

            public DataCell getCell(DataRow row) {
                Document document;
                DataCell inputCell = row.getCell(inputColumnIdx);
                if (inputCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                try {
                    document = HtmlParserNodeModel.this.parse(inputCell);
                }
                catch (ParserException e) {
                    logger.warn((Object)("Error parsing document in row " + String.valueOf(row.getKey()) + ": " + e.getMessage()), (Throwable)e);
                    return DataType.getMissingCell();
                }
                if (makeAbsoluteUrls) {
                    UrlHelper.makeAbsoluteUrls((Document)document);
                }
                try {
                    String xmlString = HtmlHelper.xmlToString((Node)document);
                    return XMLCellFactory.create((String)xmlString);
                }
                catch (Exception e) {
                    logger.warn((Object)("Error creating the result in row " + String.valueOf(row.getKey()) + ": " + e.getMessage()), (Throwable)e);
                    return DataType.getMissingCell();
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        if (this.nodeSettings.dropInputColumn.getBooleanValue()) {
            rearranger.remove(new int[]{inputColumnIdx});
        }
        return rearranger;
    }

    /*
     * Loose catch block
     */
    private Document parse(DataCell inputCell) throws ParserException {
        DocumentParser parser = ParserFactory.createHtmlParser2();
        DataType type = inputCell.getType();
        if (type.isCompatible(HttpResultValue.class)) {
            HttpResult httpResult = ((HttpResultValue)inputCell).getHttpResult();
            Document document = parser.parse(httpResult);
            if (httpResult.getLocations().isEmpty()) {
                logger.debugWithFormat("Legacy fallback: Set Document URI via HTTP Result\u2019s URL: %s", new Object[]{httpResult.getUrl()});
                document.setDocumentURI(httpResult.getUrl());
            }
            return document;
        }
        if (type.isCompatible(BinaryObjectDataValue.class)) {
            BinaryObjectDataValue binaryObject = (BinaryObjectDataValue)inputCell;
            try {
                Throwable document = null;
                Object var6_15 = null;
                try (InputStream inputStream = binaryObject.openInputStream();){
                    return parser.parse(inputStream);
                }
                catch (Throwable throwable) {
                    if (document == null) {
                        document = throwable;
                    } else if (document != throwable) {
                        document.addSuppressed(throwable);
                    }
                    throw document;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not open input stream for BinaryObjectDataValue", e);
            }
        }
        if (type.isCompatible(FSLocationValue.class)) {
            FSLocationValue fsLocationValue = (FSLocationValue)inputCell;
            try {
                Throwable e = null;
                Object var6_17 = null;
                try (FSPathProviderFactory ppFactory = FSPathProviderFactory.newFactory(Optional.empty(), (FSLocationSpec)fsLocationValue.getFSLocation());){
                    Document document;
                    FSPathProvider pathProvider;
                    Throwable throwable;
                    block39: {
                        throwable = null;
                        Object var9_23 = null;
                        pathProvider = ppFactory.create(fsLocationValue.getFSLocation());
                        NoConfigURIExporterFactory uriExporterFactory = pathProvider.getFSConnection().getDefaultURIExporterFactory();
                        URI uri = uriExporterFactory.getExporter().toUri(pathProvider.getPath());
                        File file = FileUtil.getFileFromURL((URL)uri.toURL());
                        FileInputStream inputStream = new FileInputStream(file);
                        document = parser.parse((InputStream)inputStream);
                        if (pathProvider == null) break block39;
                        pathProvider.close();
                    }
                    return document;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (pathProvider != null) {
                                    pathProvider.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new IllegalStateException("Could not read file for location cell", e);
            }
        }
        if (type.isCompatible(StringValue.class)) {
            String inputString = ((StringValue)inputCell).getStringValue();
            if (inputString.toLowerCase().matches("(file|https?):.*")) {
                if (inputString.toLowerCase().matches("https?://.*") && !this.httpUrlWarningShown) {
                    this.setWarningMessage("Input of http(s) URLs is deprecated. Connect an upstream \u201cHTTP Retriever\u201d node and parse the \u201cHTTP Result\u201d cells instead.");
                    this.httpUrlWarningShown = true;
                }
                return parser.parse(new InputSource(inputString));
            }
            return parser.parse(new InputSource(new StringReader(inputString)));
        }
        throw new IllegalStateException("Unsupported type: " + String.valueOf(type));
    }

    protected void reset() {
        this.httpUrlWarningShown = false;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.nodeSettings.columnName.getStringValue(), HtmlParserNodeDialog.INPUT_TYPES);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, HtmlParserNodeDialog.INPUT_TYPES);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.nodeSettings.columnName.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }
}

