/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.sitemap;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.bouncycastle.util.Arrays;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.nodes.KnimeProgressAdapter;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.sitemap.SitemapRetrieverNodeSettings;
import ws.palladian.retrieval.analysis.Sitemap;
import ws.palladian.retrieval.analysis.SitemapRetriever;

final class SitemapRetrieverNodeModel
extends NodeModel {
    private final SitemapRetrieverNodeSettings nodeSettings = new SitemapRetrieverNodeSettings();

    SitemapRetrieverNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        String inputColumnName = this.nodeSettings.inputColumn.getStringValue();
        BufferedDataTable inputTable = inData[0];
        DataTableSpec inputSpec = inputTable.getSpec();
        int inputColumnIdx = inputSpec.findColumnIndex(inputColumnName);
        DataTableSpec outSpec = this.createOutSpec(inputSpec);
        BufferedDataContainer container = exec.createDataContainer(outSpec);
        for (DataRow inRow : inputTable) {
            final ExecutionContext subExecContext = exec.createSubExecutionContext(1.0 / (double)inputTable.size());
            DataCell inputCell = inRow.getCell(inputColumnIdx);
            if (inputCell.isMissing()) {
                Object[] outCells = new DataCell[3];
                Arrays.fill((Object[])outCells, (Object)DataType.getMissingCell());
                AppendedColumnRow outRow = new AppendedColumnRow(inRow.getKey(), inRow, (DataCell[])outCells);
                container.addRowToTable((DataRow)outRow);
                subExecContext.setProgress(1.0);
                continue;
            }
            final StringValue urlInput = (StringValue)inputCell;
            subExecContext.setMessage("Processing " + String.valueOf(urlInput));
            KnimeProgressAdapter progressAdapter = new KnimeProgressAdapter((ExecutionMonitor)subExecContext){

                @Override
                public void increment(long steps) {
                    super.increment(steps);
                    subExecContext.setMessage("Processed " + this.currentSteps + " sitemap file(s) from " + String.valueOf(urlInput));
                }
            };
            Sitemap sitemap = new SitemapRetriever().getSitemap(urlInput.getStringValue(), SitemapRetriever.ALL, true, (ProgressReporter)progressAdapter);
            int urlIdx = 0;
            for (Sitemap.Entry url : sitemap.getUrlSet()) {
                StringCell locationCell = new StringCell(url.getLocation());
                DataCell priorityCell = Optional.ofNullable(url.getPriority()).map(DoubleCell::new).orElseGet(DataType::getMissingCell);
                DataCell lastmodCell = Optional.ofNullable(url.getLastModified()).map(lastmod -> LocalDateTimeCellFactory.create((LocalDateTime)lastmod.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime())).orElseGet(DataType::getMissingCell);
                DataCell[] appendedCols = new DataCell[]{locationCell, lastmodCell, priorityCell};
                RowKey rowKey = new RowKey(String.valueOf(inRow.getKey()) + "_" + urlIdx);
                AppendedColumnRow outRow = new AppendedColumnRow(rowKey, inRow, appendedCols);
                container.addRowToTable((DataRow)outRow);
                exec.checkCanceled();
                ++urlIdx;
            }
        }
        container.close();
        BufferedDataTable outputTable = container.getTable();
        return new BufferedDataTable[]{outputTable};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), StringValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.inputColumn.setStringValue(inColSpec.getName());
        }
        return new DataTableSpec[]{this.createOutSpec(inSpec)};
    }

    private DataTableSpec createOutSpec(DataTableSpec inSpec) {
        String inputColumnName = this.nodeSettings.inputColumn.getStringValue();
        return new DataTableSpecCreator(inSpec).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(inputColumnName + ": loc", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(inputColumnName + ": lastmod", LocalDateTimeCellFactory.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(inputColumnName + ": priority", DoubleCell.TYPE).createSpec()}).createSpec();
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

