/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.multipart;

import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.retrieval.utils.multipart.MultipartEncodedHttpEntityCreateNodeSettings;
import ws.palladian.retrieval.HttpEntity;
import ws.palladian.retrieval.InputStreamHttpEntity;
import ws.palladian.retrieval.MultipartHttpEntity;
import ws.palladian.retrieval.StringHttpEntity;

class MultipartEncodedHttpEntityCreatorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final MultipartEncodedHttpEntityCreateNodeSettings settings = new MultipartEncodedHttpEntityCreateNodeSettings();
    private BinaryObjectCellFactory binaryFactory;
    private String boundary = null;

    MultipartEncodedHttpEntityCreatorNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        this.binaryFactory = new BinaryObjectCellFactory(exec);
        return super.execute(inData, exec);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        this.boundary = "xoxoxoxoxoxoxoxoxoxo_" + System.currentTimeMillis();
        String contentType = new MultipartHttpEntity.Builder().setBoundary(this.boundary).create().getContentType();
        this.pushFlowVariableString(this.settings.getContentTypeOutColName(), contentType);
        return super.configure(inSpecs);
    }

    protected ColumnRearranger createColumnRearranger(final DataTableSpec inSpec) throws InvalidSettingsException {
        AbstractCellFactory cellFactory = new AbstractCellFactory(this.createAppendedColumnSpec()){

            public DataCell[] getCells(DataRow row) {
                MultipartHttpEntity.Builder builder = new MultipartHttpEntity.Builder();
                builder.setBoundary(MultipartEncodedHttpEntityCreatorNodeModel.this.boundary);
                for (MultipartEncodedHttpEntityCreateNodeSettings.SettingsEntry settingsEntry : MultipartEncodedHttpEntityCreatorNodeModel.this.settings) {
                    int entityIdx = inSpec.findColumnIndex(settingsEntry.entityInputColumn);
                    DataCell cell = row.getCell(entityIdx);
                    if (cell instanceof BinaryObjectDataValue) {
                        InputStreamHttpEntity entity;
                        BinaryObjectDataValue binaryValue = (BinaryObjectDataValue)cell;
                        try {
                            entity = new InputStreamHttpEntity(binaryValue.openInputStream(), binaryValue.length(), settingsEntry.entityContentType);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Could not open input stream for input in row " + String.valueOf(row.getKey()), e);
                        }
                        builder.addPart((HttpEntity)entity, settingsEntry.name, settingsEntry.fileName);
                        continue;
                    }
                    if (cell instanceof StringValue) {
                        String stringValue = ((StringValue)cell).getStringValue();
                        builder.addPart((HttpEntity)new StringHttpEntity(stringValue, settingsEntry.entityContentType), settingsEntry.name, settingsEntry.fileName);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected type for input cell: " + cell.getClass().getName());
                }
                MultipartHttpEntity multipartEntity = builder.create();
                try {
                    return new DataCell[]{MultipartEncodedHttpEntityCreatorNodeModel.this.binaryFactory.create(multipartEntity.getInputStream()), new StringCell(multipartEntity.getContentType())};
                }
                catch (IOException e) {
                    throw new IllegalStateException("Exception while trying to create binary cell", e);
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }

    private DataColumnSpec[] createAppendedColumnSpec() {
        return new DataColumnSpec[]{new DataColumnSpecCreator(this.settings.getEntityOutColName(), BinaryObjectDataCell.TYPE).createSpec(), new DataColumnSpecCreator(this.settings.getContentTypeOutColName(), StringCell.TYPE).createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
        this.binaryFactory = null;
        this.boundary = null;
    }
}

