/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import com.github.scribejava.core.builder.ServiceBuilderCommon;
import com.github.scribejava.core.builder.ServiceBuilderOAuth20;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.Icon;
import org.eclipse.jetty.server.Request;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.workflow.FlowVariable;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.oauth.OAuthApiFactoryRegistry;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.OAuthNodeSettings;

public class OAuth20Flow
extends OAuthFlow {
    private static final String CFGKEY_REFRESH_TOKEN = "refreshToken";
    private static final String CFGKEY_SCOPE = "scope";
    private static final String CFGKEY_TYPE = "type";
    private static final String CFGKEY_EXPIRES_IN = "expiresIn";
    private static final String CFGKEY_EXPIRES_AT = "expiresAt";
    private final OAuth20Service service;

    private OAuth20Flow(OAuth20Service service) {
        this.service = service;
    }

    @Override
    public String getBrowserUrl() {
        return this.service.getAuthorizationUrl();
    }

    @Override
    public boolean validCallbackResponse(Request request) {
        return request.getHttpURI().getPath().equals("/") && request.getHttpURI().getQuery() != null && request.getHttpURI().getQuery().contains("code=");
    }

    @Override
    public void saveToken(Request request, OAuthNodeSettings nodeSettings) throws Exception {
        Map<String, String> params = OAuth20Flow.parseQueryParams(request.getHttpURI().getQuery());
        String code = params.get("code");
        OAuth2AccessToken accessTokenResult = this.service.getAccessToken(code);
        nodeSettings.accessToken.setStringValue(accessTokenResult.getAccessToken());
        nodeSettings.refreshToken.setStringValue(accessTokenResult.getRefreshToken());
        nodeSettings.scope.setStringValue(accessTokenResult.getScope());
        nodeSettings.tokenType.setStringValue(accessTokenResult.getTokenType());
        Integer expiresInOrNull = accessTokenResult.getExpiresIn();
        nodeSettings.expiresIn.setIntValue(Optional.ofNullable(expiresInOrNull).orElse(-1).intValue());
    }

    @Override
    public OAuth20Data extractToken(Request request) throws Exception {
        Map<String, String> params = OAuth20Flow.parseQueryParams(request.getHttpURI().getQuery());
        String code = params.get("code");
        OAuth2AccessToken accessTokenResult = this.service.getAccessToken(code);
        Integer expiresInOrNull = accessTokenResult.getExpiresIn();
        return new OAuth20Data(accessTokenResult.getAccessToken(), accessTokenResult.getRefreshToken(), accessTokenResult.getScope(), accessTokenResult.getTokenType(), Optional.ofNullable(expiresInOrNull).orElse(-1), OAuth20Flow.createExpiresAtStringOrNull(expiresInOrNull), accessTokenResult.getRawResponse(), this);
    }

    private static String createExpiresAtStringOrNull(Integer expiresInSecondsOrNull) {
        if (expiresInSecondsOrNull == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(Instant.now().plus((long)expiresInSecondsOrNull.intValue(), ChronoUnit.SECONDS), ZoneId.systemDefault()).toString();
    }

    public static final class OAuth20Api
    extends OAuthApiFactoryRegistry.OAuthAPI {
        private final DefaultApi20 api;

        OAuth20Api(String name, Icon icon, DefaultApi20 api, String websiteUrl, boolean deprecated) {
            super(name, icon, websiteUrl, deprecated);
            this.api = api;
        }

        public OAuth20Api(DefaultApi20 api) {
            super(null, null, null, false);
            this.api = api;
        }

        @Override
        public OAuthFlow createFlow(ServiceBuilderCommon serviceBuilder) {
            return new OAuth20Flow(((ServiceBuilderOAuth20)serviceBuilder).build(this.api));
        }

        @Override
        public DataTableSpec getSpec() {
            return new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("accessToken", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(OAuth20Flow.CFGKEY_REFRESH_TOKEN, StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(OAuth20Flow.CFGKEY_SCOPE, StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("tokenType", StringCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(OAuth20Flow.CFGKEY_EXPIRES_IN, IntCell.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(OAuth20Flow.CFGKEY_EXPIRES_AT, ZonedDateTimeCellFactory.TYPE).createSpec()}).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("rawResponse", StringCell.TYPE).createSpec()}).createSpec();
        }

        @Override
        public OAuthFlow.OAuthData loadSettings(ServiceBuilderCommon serviceBuilder, NodeSettingsRO tokenSettings) throws InvalidSettingsException {
            String accessToken = tokenSettings.getString("accessToken");
            String refreshToken = tokenSettings.getString(OAuth20Flow.CFGKEY_REFRESH_TOKEN);
            String scope = tokenSettings.getString(OAuth20Flow.CFGKEY_SCOPE);
            String tokenType = tokenSettings.getString(OAuth20Flow.CFGKEY_TYPE);
            int expiresIn = tokenSettings.getInt(OAuth20Flow.CFGKEY_EXPIRES_IN);
            String expiresAt = tokenSettings.getString(OAuth20Flow.CFGKEY_EXPIRES_AT);
            String rawResponse = tokenSettings.getString("rawResponse");
            return new OAuth20Data(accessToken, refreshToken, scope, tokenType, expiresIn, expiresAt, rawResponse, (OAuth20Flow)this.createFlow(serviceBuilder));
        }

        @Override
        public String getIdentifier() {
            return this.api.getClass().getName();
        }
    }

    public static class OAuth20Data
    implements OAuthFlow.OAuthData {
        private final String accessToken;
        private final String refreshToken;
        private final String scope;
        private final String tokenType;
        private final int expiresIn;
        private final String expiresAt;
        private final String rawResponse;
        private final OAuth20Flow flow;

        private OAuth20Data(String accessToken, String refreshToken, String scope, String tokenType, int expiresIn, String expiresAt, String rawResponse, OAuth20Flow flow) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.scope = scope;
            this.tokenType = tokenType;
            this.expiresIn = expiresIn;
            this.expiresAt = expiresAt;
            this.flow = flow;
            this.rawResponse = rawResponse;
        }

        @Override
        public List<DataCell> getCells() {
            ArrayList<DataCell> cells = new ArrayList<DataCell>();
            cells.add(PalladianKnimeHelper.createStringCell((String)this.accessToken));
            cells.add(PalladianKnimeHelper.createStringCell((String)this.refreshToken));
            cells.add(PalladianKnimeHelper.createStringCell((String)this.scope));
            cells.add(PalladianKnimeHelper.createStringCell((String)this.tokenType));
            if (this.expiresIn == -1) {
                cells.add(DataType.getMissingCell());
                cells.add(DataType.getMissingCell());
            } else {
                cells.add((DataCell)new IntCell(this.expiresIn));
                cells.add(ZonedDateTimeCellFactory.create((String)this.expiresAt));
            }
            cells.add(PalladianKnimeHelper.createStringCell((String)this.rawResponse));
            return cells;
        }

        @Override
        public List<FlowVariable> getFlowVariables() {
            ArrayList<FlowVariable> variables = new ArrayList<FlowVariable>();
            variables.add(new FlowVariable("accessToken", this.accessToken));
            variables.add(new FlowVariable(OAuth20Flow.CFGKEY_REFRESH_TOKEN, this.refreshToken));
            variables.add(new FlowVariable(OAuth20Flow.CFGKEY_SCOPE, this.scope));
            variables.add(new FlowVariable("tokenType", this.tokenType));
            if (this.expiresIn != -1) {
                variables.add(new FlowVariable(OAuth20Flow.CFGKEY_EXPIRES_IN, this.expiresIn));
                variables.add(new FlowVariable(OAuth20Flow.CFGKEY_EXPIRES_AT, this.expiresAt));
            }
            variables.add(new FlowVariable("rawResponse", this.rawResponse));
            return variables;
        }

        @Override
        public OAuthFlow.OAuthData refreshToken() throws Exception {
            if (StringUtils.nullOrEmpty((String)this.refreshToken)) {
                return this;
            }
            OAuth2AccessToken accessTokenResult = this.flow.service.refreshAccessToken(this.refreshToken);
            Integer expiresInOrNull = accessTokenResult.getExpiresIn();
            return new OAuth20Data(accessTokenResult.getAccessToken(), this.refreshToken, this.scope, this.tokenType, Optional.ofNullable(expiresInOrNull).orElse(-1), OAuth20Flow.createExpiresAtStringOrNull(expiresInOrNull), accessTokenResult.getRawResponse(), this.flow);
        }

        @Override
        public void saveSettings(NodeSettingsWO tokenSettings) {
            tokenSettings.addString("accessToken", this.accessToken);
            tokenSettings.addString(OAuth20Flow.CFGKEY_REFRESH_TOKEN, this.refreshToken);
            tokenSettings.addString(OAuth20Flow.CFGKEY_SCOPE, this.scope);
            tokenSettings.addString(OAuth20Flow.CFGKEY_TYPE, this.tokenType);
            tokenSettings.addInt(OAuth20Flow.CFGKEY_EXPIRES_IN, this.expiresIn);
            tokenSettings.addString(OAuth20Flow.CFGKEY_EXPIRES_AT, this.expiresAt);
            tokenSettings.addString("rawResponse", this.rawResponse);
        }

        @Override
        public boolean needsRefresh() {
            if (this.expiresAt == null) {
                return false;
            }
            ZonedDateTime expiresAtDateTime = ZonedDateTime.parse(this.expiresAt);
            return expiresAtDateTime.isBefore(ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        }
    }
}

