/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth;

import com.github.scribejava.core.builder.ServiceBuilderCommon;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.builder.api.DefaultApi20;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.util.StringIconOption;
import org.osgi.framework.Bundle;
import ws.palladian.nodes.oauth.OAuth10aFlow;
import ws.palladian.nodes.oauth.OAuth20Flow;
import ws.palladian.nodes.oauth.OAuthFlow;

public final class OAuthApiFactoryRegistry {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(OAuthApiFactoryRegistry.class);
    private static final String EXTENSION_POINT_ID = "ws.palladian.nodes.oauth.api";
    private static final String ELEMENT_AUTH_2_0 = "oauth-2.0";
    private static final String ELEMENT_OAUTH_1_0A = "oauth-1.0a";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ATTRIBUTE_API_CLASS = "api-class";
    private static final String ATTRIBUTE_WEBSITE_URL = "website-url";
    private static final String ATTRIBUTE_DEPRECATED = "deprecated";
    private static final List<OAuthAPI> OAUTH_APIS = OAuthApiFactoryRegistry.loadApis();

    private static List<OAuthAPI> loadApis() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension point ws.palladian.nodes.oauth.api");
        }
        ArrayList<OAuthAPI> apis = new ArrayList<OAuthAPI>();
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                apis.add(OAuthApiFactoryRegistry.initalize(element));
            }
            catch (Exception e) {
                LOGGER.coding((Object)("Could not initialize extension: " + e.getMessage()), (Throwable)e);
            }
            ++n2;
        }
        Collections.sort(apis, Comparator.comparing(a -> a.getNameForUI().toLowerCase()));
        return Collections.unmodifiableList(apis);
    }

    private static OAuthAPI initalize(IConfigurationElement element) {
        Object api;
        Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
        String apiClassName = element.getAttribute(ATTRIBUTE_API_CLASS);
        try {
            Class apiClass = bundle.loadClass(apiClassName);
            Method instanceMethod = apiClass.getMethod("instance", new Class[0]);
            api = instanceMethod.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        return OAuthApiFactoryRegistry.createApi(element, bundle, api);
    }

    private static OAuthAPI createApi(IConfigurationElement element, Bundle bundle, Object api) {
        URL[] entries;
        String name = element.getAttribute(ATTRIBUTE_NAME);
        String iconPath = element.getAttribute(ATTRIBUTE_ICON);
        ImageIcon icon = null;
        if (iconPath != null && (entries = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(iconPath))).length == 1) {
            icon = new ImageIcon(entries[0]);
        }
        String websiteUrl = element.getAttribute(ATTRIBUTE_WEBSITE_URL);
        boolean deprecated = Boolean.valueOf(element.getAttribute(ATTRIBUTE_DEPRECATED));
        if (ELEMENT_OAUTH_1_0A.equals(element.getName()) && api instanceof DefaultApi10a) {
            return new OAuth10aFlow.OAuth10aApi(name, icon, (DefaultApi10a)api, websiteUrl, deprecated);
        }
        if (ELEMENT_AUTH_2_0.equals(element.getName()) && api instanceof DefaultApi20) {
            return new OAuth20Flow.OAuth20Api(name, icon, (DefaultApi20)api, websiteUrl, deprecated);
        }
        throw new IllegalStateException("Unexpected type: " + element.getName() + " vs. " + String.valueOf(api.getClass()));
    }

    public static List<OAuthAPI> getApis() {
        return OAuthApiFactoryRegistry.getApis(false);
    }

    public static List<OAuthAPI> getApis(boolean includeDeprecated) {
        return OAUTH_APIS.stream().filter(a -> includeDeprecated || !a.isDeprecated()).collect(Collectors.toList());
    }

    public static OAuthAPI getAPI(String name) {
        return OAUTH_APIS.stream().filter(a -> a.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such API: " + name));
    }

    public static OAuthAPI getApiByIdentifier(String identifier) {
        return OAUTH_APIS.stream().filter(a -> a.getIdentifier().equals(identifier)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such API: " + identifier));
    }

    private OAuthApiFactoryRegistry() {
    }

    public static abstract class OAuthAPI
    implements StringIconOption {
        private final String name;
        private final Icon icon;
        private final String websiteUrl;
        private final boolean deprecated;

        protected OAuthAPI(String name, Icon icon, String websiteUrl, boolean deprecated) {
            this.name = name;
            this.icon = icon;
            this.websiteUrl = websiteUrl;
            this.deprecated = deprecated;
        }

        public String getName() {
            return this.name;
        }

        public String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public abstract OAuthFlow createFlow(ServiceBuilderCommon var1);

        public String getText() {
            return this.getName();
        }

        public Icon getIcon() {
            return this.icon;
        }

        public abstract DataTableSpec getSpec();

        public abstract OAuthFlow.OAuthData loadSettings(ServiceBuilderCommon var1, NodeSettingsRO var2) throws InvalidSettingsException;

        public abstract String getIdentifier();

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getNameForUI() {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(this.getName());
            if (this.isDeprecated()) {
                nameBuilder.append(" (deprecated)");
            }
            return nameBuilder.toString();
        }
    }
}

