/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth.custom;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.text.StringEscapeUtils;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.VariableType;
import ws.palladian.nodes.oauth.LocalOAuthServer;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.custom.CustomOAuthNodeSettings;

class CustomOAuthNodeDialog
extends DefaultNodeSettingsPane {
    static final NodeLogger LOGGER = NodeLogger.getLogger(CustomOAuthNodeDialog.class);
    private final CustomOAuthNodeSettings nodeSettings = new CustomOAuthNodeSettings();
    private final DialogComponentNumber portComponent;
    private final DialogComponentString apiKeyComponent;
    private final DialogComponentString apiSecretComponent;
    private final DialogComponentString authUrlComponent;
    private final DialogComponentString tokenUrlComponent;
    private final DialogComponentString refreshUrlComponent;
    private final DialogComponentString scopeComponent;
    private final DialogComponentLabel messageLabel;
    private final DialogComponentButton authorizeButton;
    private final DialogComponentButton clearButton;
    final FlowVariableModel portFv = this.createFlowVariableModel("port", (VariableType)VariableType.IntType.INSTANCE);
    final FlowVariableModel apiKeyFv = this.createFlowVariableModel("apiKexy", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel apiSecretFv = this.createFlowVariableModel("apiSecret", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel authUrlFv = this.createFlowVariableModel("authorizationUrl", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel tokenUrlFv = this.createFlowVariableModel("tokenUrl", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel refreshUrlFv = this.createFlowVariableModel("refreshUrl", (VariableType)VariableType.StringType.INSTANCE);
    final FlowVariableModel scopeFv = this.createFlowVariableModel("scope", (VariableType)VariableType.StringType.INSTANCE);
    private LocalOAuthServer oAuthServer;

    CustomOAuthNodeDialog() {
        this.apiKeyComponent = new DialogComponentString(this.nodeSettings.apiKey, "API Key", false, 30, this.apiKeyFv);
        this.addDialogComponent((DialogComponent)this.apiKeyComponent);
        this.apiSecretComponent = new DialogComponentString(this.nodeSettings.apiSecret, "API Secret", false, 30, this.apiSecretFv);
        this.addDialogComponent((DialogComponent)this.apiSecretComponent);
        this.authUrlComponent = new DialogComponentString(this.nodeSettings.authorizationUrl, "Authorization URL", false, 30, this.authUrlFv);
        this.addDialogComponent((DialogComponent)this.authUrlComponent);
        this.tokenUrlComponent = new DialogComponentString(this.nodeSettings.tokenUrl, "Token URL", false, 30, this.tokenUrlFv);
        this.addDialogComponent((DialogComponent)this.tokenUrlComponent);
        this.refreshUrlComponent = new DialogComponentString(this.nodeSettings.refreshUrl, "Refresh URL", false, 30, this.refreshUrlFv);
        this.addDialogComponent((DialogComponent)this.refreshUrlComponent);
        this.portComponent = new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.port, "Callback URL Port (http://localhost:XXXXX)", (Number)1, this.portFv);
        this.addDialogComponent((DialogComponent)this.portComponent);
        this.scopeComponent = new DialogComponentString(this.nodeSettings.scope, "Scope", false, 30, this.scopeFv);
        this.addDialogComponent((DialogComponent)this.scopeComponent);
        this.messageLabel = new DialogComponentLabel("");
        this.addDialogComponent((DialogComponent)this.messageLabel);
        this.setHorizontalPlacement(true);
        this.authorizeButton = new DialogComponentButton("Authorize Access");
        this.addDialogComponent((DialogComponent)this.authorizeButton);
        this.authorizeButton.addActionListener(e -> {
            String browserUrl;
            final CustomOAuthNodeSettings nodeSettingsCopyWithFV = this.nodeSettings.createForDialog(this);
            try {
                nodeSettingsCopyWithFV.validateSettingsForAuth();
            }
            catch (InvalidSettingsException ex) {
                JOptionPane.showMessageDialog(this.getPanel(), ex.getMessage(), null, 0);
                return;
            }
            final OAuthFlow flow = nodeSettingsCopyWithFV.createFlow();
            try {
                browserUrl = flow.getBrowserUrl();
            }
            catch (Exception ex) {
                String msg = "<html><body><p style='width:300px'>" + StringEscapeUtils.escapeHtml4((String)ex.getMessage()) + "</p></body></html>";
                JOptionPane.showMessageDialog(this.getPanel(), msg, null, 0);
                return;
            }
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    int port = nodeSettingsCopyWithFV.port.getIntValue();
                    try {
                        CustomOAuthNodeDialog.this.updateStatus("Starting HTTP server on " + port, null);
                        CustomOAuthNodeDialog.this.oAuthServer = LocalOAuthServer.start(port, flow);
                        CustomOAuthNodeDialog.this.oAuthServer.onUpdateStatus((message, exception) -> CustomOAuthNodeDialog.this.updateStatus((String)message, (Exception)exception));
                        CustomOAuthNodeDialog.this.oAuthServer.onReceivedCode(token -> {
                            CustomOAuthNodeDialog.this.nodeSettings.setOAuthToken((OAuthFlow.OAuthData)token);
                            CustomOAuthNodeDialog.this.updateComponentsAndMessageLabel();
                        });
                    }
                    catch (Exception e) {
                        CustomOAuthNodeDialog.this.updateStatus("Could not start HTTP server on port " + port + ": " + e.getMessage(), e);
                        return null;
                    }
                    Desktop.getDesktop().browse(new URI(browserUrl));
                    CustomOAuthNodeDialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                    return null;
                }
            }.execute();
        });
        this.clearButton = new DialogComponentButton("Clear Token");
        this.addDialogComponent((DialogComponent)this.clearButton);
        this.clearButton.addActionListener(e -> {
            this.nodeSettings.setOAuthToken(null);
            this.updateComponentsAndMessageLabel();
        });
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        try {
            this.nodeSettings.loadValidatedSettingsFrom(settings);
            this.updateComponentsAndMessageLabel();
        }
        catch (InvalidSettingsException e) {
            LOGGER.debug((Object)"Encountered ISE", (Throwable)e);
        }
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.saveSettingsTo(settings);
    }

    public void onClose() {
        if (this.oAuthServer != null) {
            this.oAuthServer.stop();
        }
    }

    private void updateComponentsAndMessageLabel() {
        boolean hasToken = this.nodeSettings.getOAuthToken() != null;
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.portComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.apiKeyComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.apiSecretComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.authUrlComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.tokenUrlComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.refreshUrlComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.scopeComponent, !hasToken);
        CustomOAuthNodeDialog.enableOrDisableComponent((DialogComponent)this.clearButton, hasToken);
        if (hasToken) {
            this.updateStatus("Successfully received an access token.", null);
        } else {
            this.updateStatus("Click the button to request an access token.", null);
        }
    }

    private static void enableOrDisableComponent(DialogComponent component, boolean state) {
        Arrays.stream(component.getComponentPanel().getComponents()).forEach(c -> c.setEnabled(state));
    }

    private void updateStatus(String message, Exception ex) {
        this.messageLabel.setText(message);
        JLabel jLabel = (JLabel)this.messageLabel.getComponentPanel().getComponent(0);
        if (ex != null) {
            jLabel.setForeground(Color.RED);
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            jLabel.setForeground(Color.BLACK);
            LOGGER.info((Object)message);
        }
    }
}

