/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth.custom;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.workflow.VariableType;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.custom.CustomOAuthNodeSettings;

class CustomOAuthNodeModel
extends NodeModel {
    private final CustomOAuthNodeSettings nodeSettings = new CustomOAuthNodeSettings();

    protected CustomOAuthNodeModel() {
        super(0, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        exec.setProgress("Refreshing token \u2026");
        OAuthFlow.OAuthData refreshedOAuthData = this.nodeSettings.getOAuthToken().refreshToken();
        BufferedDataContainer container = exec.createDataContainer(this.nodeSettings.oauthApi.getSpec());
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), refreshedOAuthData.getCells()));
        container.close();
        refreshedOAuthData.getFlowVariables().forEach(variable -> {
            VariableType type = variable.getVariableType();
            this.pushFlowVariable(variable.getName(), type, variable.getValue(type));
        });
        return new BufferedDataTable[]{container.getTable()};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (this.nodeSettings.getOAuthToken() == null) {
            throw new InvalidSettingsException("Please configure the node and authorize access through the corresponding button.");
        }
        return new DataTableSpec[]{this.nodeSettings.oauthApi.getSpec()};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        if (this.nodeSettings.getOAuthToken().needsRefresh()) {
            this.setWarningMessage("The token is expired \u2013 please re-execute the node.");
        }
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
    }
}

