/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.oauth.v2;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.ServiceBuilderCommon;
import java.io.OutputStream;
import java.util.ArrayList;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.oauth.LogOutputStream;
import ws.palladian.nodes.oauth.OAuthApiFactoryRegistry;
import ws.palladian.nodes.oauth.OAuthFlow;
import ws.palladian.nodes.oauth.v2.OAuthNode2Dialog;

class OAuthNode2Settings
implements NodeSettings {
    static final NodeLogger LOGGER = NodeLogger.getLogger(OAuthNode2Settings.class);
    static final String CFGKEY_SERVICE = "service";
    static final String CFGKEY_API_KEY = "apiKey";
    static final String CFGKEY_API_SECRET = "apiSecret";
    static final String CFGKEY_DEFAULT_SCOPE = "defaultScope";
    private static final String CFGKEY_TOKEN_DATA = "tokenData";
    final SettingsModelString service = new SettingsModelString("service", null);
    final SettingsModelString apiKey = new SettingsModelString("apiKey", null);
    final SettingsModelString apiSecret = new SettingsModelString("apiSecret", null);
    final SettingsModelString defaultScope = new SettingsModelString("defaultScope", null);
    private final SettingsModel[] settings = new SettingsModel[]{this.service, this.apiKey, this.defaultScope, this.apiSecret};
    private OAuthFlow.OAuthData oAuthToken;

    OAuthNode2Settings() {
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.saveSettingsTo(settings);
            ++n2;
        }
        if (this.oAuthToken != null) {
            this.oAuthToken.saveSettings(settings.addNodeSettings(CFGKEY_TOKEN_DATA));
        }
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.validateSettings(settings);
            ++n2;
        }
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        SettingsModel[] settingsModelArray = this.settings;
        int n = this.settings.length;
        int n2 = 0;
        while (n2 < n) {
            SettingsModel model = settingsModelArray[n2];
            model.loadSettingsFrom(settings);
            ++n2;
        }
        try {
            NodeSettingsRO tokenData = settings.getNodeSettings(CFGKEY_TOKEN_DATA);
            this.oAuthToken = this.getAPI().loadSettings(this.createServiceBuilder(), tokenData);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            this.oAuthToken = null;
        }
    }

    void setOAuthToken(OAuthFlow.OAuthData oAuthToken) {
        this.oAuthToken = oAuthToken;
    }

    OAuthFlow.OAuthData getOAuthToken() {
        return this.oAuthToken;
    }

    OAuthApiFactoryRegistry.OAuthAPI getAPI() {
        return OAuthApiFactoryRegistry.getApiByIdentifier(this.service.getStringValue());
    }

    OAuthFlow createFlow() {
        return this.getAPI().createFlow(this.createServiceBuilder());
    }

    private ServiceBuilderCommon createServiceBuilder() {
        ServiceBuilder serviceBuilder = new ServiceBuilder(this.apiKey.getStringValue()).apiSecret(this.apiSecret.getStringValue()).callback("http://localhost:55931").debugStream((OutputStream)new LogOutputStream(LOGGER));
        if (StringUtils.notNullOrEmpty((String)this.defaultScope.getStringValue())) {
            serviceBuilder = serviceBuilder.defaultScope(this.defaultScope.getStringValue());
        }
        return serviceBuilder;
    }

    void validateSettingsForAuth() throws InvalidSettingsException {
        ArrayList<String> missingInput = new ArrayList<String>();
        if (StringUtils.nullOrEmpty((String)this.service.getStringValue())) {
            missingInput.add("Service");
        }
        if (StringUtils.nullOrEmpty((String)this.apiKey.getStringValue())) {
            missingInput.add("API Key");
        }
        if (StringUtils.nullOrEmpty((String)this.apiSecret.getStringValue())) {
            missingInput.add("API Secret");
        }
        if (!missingInput.isEmpty()) {
            throw new InvalidSettingsException("The following input for authorizing is missing:\n" + String.join((CharSequence)", ", missingInput));
        }
    }

    OAuthNode2Settings createForDialog(OAuthNode2Dialog dialog) {
        org.knime.core.node.NodeSettings settingsTemp = new org.knime.core.node.NodeSettings("temp");
        this.saveSettingsTo((NodeSettingsWO)settingsTemp);
        OAuthNode2Settings copy = new OAuthNode2Settings();
        try {
            copy.loadValidatedSettingsFrom((NodeSettingsRO)settingsTemp);
        }
        catch (InvalidSettingsException e) {
            throw new IllegalStateException("Could not copy the settings", e);
        }
        dialog.serviceFv.getVariableValue().ifPresent(value -> oAuthNode2Settings.service.setStringValue(value.getStringValue()));
        dialog.apiKeyFv.getVariableValue().ifPresent(value -> oAuthNode2Settings.apiKey.setStringValue(value.getStringValue()));
        dialog.apiSecretFv.getVariableValue().ifPresent(value -> oAuthNode2Settings.apiSecret.setStringValue(value.getStringValue()));
        dialog.scopeFv.getVariableValue().ifPresent(value -> oAuthNode2Settings.defaultScope.setStringValue(value.getStringValue()));
        return copy;
    }
}

