/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonUtils {
    public static Object toObject(JsonValue value) {
        Objects.requireNonNull(value, "value was null");
        switch (value.getValueType()) {
            case ARRAY: {
                return ((JsonArray)value).stream().map(JsonUtils::toObject).collect(Collectors.toList());
            }
            case OBJECT: {
                return ((JsonObject)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonUtils.toObject((JsonValue)e.getValue())));
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(value.getValueType()));
    }

    public static JsonValue parse(String jsonString) {
        Objects.requireNonNull(jsonString, "jsonString was null");
        return Json.createReader((Reader)new StringReader(jsonString)).readValue();
    }

    private JsonUtils() {
    }
}

