/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.templating;

import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.templating.TemplateEngine;

class TemplatingNodeSettings
implements NodeSettings {
    final SettingsModelString template;
    final SettingsModelString variablesColumn = new SettingsModelString("variablesColumn", null);
    final SettingsModelBoolean removeVariablesColumn = new SettingsModelBoolean("removeVariablesColumn", false);
    final SettingsModelString outputColumn = new SettingsModelString("outputColumn", "Result");
    final SettingsModelString contentType;

    TemplatingNodeSettings(TemplateEngine templateEngine) {
        this.contentType = new SettingsModelString("contentType", ContentType.DEFAULT.value);
        String settingsKey = templateEngine.getName().toLowerCase() + "Template";
        this.template = new SettingsModelString(settingsKey, templateEngine.getDefaultSnippet());
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.template.saveSettingsTo(settings);
        this.variablesColumn.saveSettingsTo(settings);
        this.removeVariablesColumn.saveSettingsTo(settings);
        this.outputColumn.saveSettingsTo(settings);
        this.contentType.saveSettingsTo(settings);
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.template.loadSettingsFrom(settings);
        this.variablesColumn.loadSettingsFrom(settings);
        this.removeVariablesColumn.loadSettingsFrom(settings);
        this.outputColumn.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings((NodeSettingsRO)settings, (SettingsModel)this.contentType);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.template.validateSettings(settings);
        this.variablesColumn.validateSettings(settings);
        this.removeVariablesColumn.validateSettings(settings);
        this.outputColumn.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings((NodeSettingsRO)settings, (SettingsModel)this.contentType);
    }

    static enum ContentType {
        HTML("HTML"),
        TEXT("Text");

        static final ContentType DEFAULT;
        private final String value;

        static {
            DEFAULT = HTML;
        }

        private ContentType(String value) {
            this.value = value;
        }

        static String[] stringValues() {
            return (String[])Arrays.stream(ContentType.values()).map(t -> t.value).toArray(String[]::new);
        }

        static ContentType fromString(String str) {
            return Arrays.stream(ContentType.values()).filter(t -> t.value.equals(str)).findFirst().orElseThrow();
        }
    }
}

