/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.db;

import com.maxmind.db.CHMCache;
import com.maxmind.db.Metadata;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AbstractResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.maxmind.geoip2.connector.db.GeoIP2DBConnectorNodeSettings;
import ws.palladian.nodes.maxmind.geoip2.connector.port.AbstractGeoIP2ConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2Extractor;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;

public final class GeoIP2DBConnectorPortObjectSpec
extends AbstractGeoIP2ConnectorPortObjectSpec {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(GeoIP2DBConnectorPortObjectSpec.class);
    private String database;

    public GeoIP2DBConnectorPortObjectSpec() {
    }

    public GeoIP2DBConnectorPortObjectSpec(String database) {
        this.database = database;
    }

    GeoIP2DBConnectorPortObjectSpec(GeoIP2DBConnectorNodeSettings nodeSettings) {
        this(nodeSettings.getSettingDatabaseFile().getStringValue());
    }

    protected void save(ModelContentWO model) {
        model.addString("databaseFile", this.database);
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.database = model.getString("databaseFile");
    }

    @Override
    protected String getSummary() {
        try {
            Set<? extends ResponseType> supportedTypes = this.getSupportedResponseTypes();
            return "File: " + this.database + ", supported types: " + String.valueOf(supportedTypes);
        }
        catch (InvalidSettingsException e) {
            return e.getMessage();
        }
    }

    @Override
    public Set<? extends ResponseType> getSupportedResponseTypes() throws InvalidSettingsException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DatabaseReader databaseReader = this.getDatabaseReader();){
                return GeoIP2DBConnectorPortObjectSpec.getDatabaseType(databaseReader.getMetadata());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new InvalidSettingsException("Could not determine database type; file " + this.database + " cannot be read.", (Throwable)e);
        }
    }

    @Override
    public GeoIP2Extractor createExtractor(final ResponseType type) throws Exception {
        final DatabaseReader provider = this.getDatabaseReader();
        return new GeoIP2Extractor(){

            @Override
            public AbstractResponse execute(InetAddress ipAddress) throws IOException, GeoIp2Exception {
                switch (type) {
                    case ASN: {
                        return provider.asn(ipAddress);
                    }
                    case CITY: {
                        return provider.city(ipAddress);
                    }
                    case COUNTRY: {
                        return provider.country(ipAddress);
                    }
                }
                throw new IllegalStateException("Unsupported result type: " + String.valueOf((Object)type));
            }

            @Override
            public void close() throws Exception {
                provider.close();
            }
        };
    }

    private DatabaseReader getDatabaseReader() throws IOException {
        File dbFile = PalladianKnimeHelper.getFileFromUrlOrPath((String)this.database);
        LOGGER.debugWithFormat("Creating DatabaseReader for %s", new Object[]{dbFile});
        return new DatabaseReader.Builder(dbFile).withCache((NodeCache)new CHMCache()).build();
    }

    private static Set<? extends ResponseType> getDatabaseType(Metadata metadata) {
        String databaseType = metadata.getDatabaseType();
        LinkedHashSet<ResponseType> types = new LinkedHashSet<ResponseType>();
        if (databaseType.contains("GeoLite2-ASN")) {
            types.add(ResponseType.ASN);
        }
        if (databaseType.contains("City")) {
            types.addAll(Arrays.asList(ResponseType.CITY, ResponseType.COUNTRY));
        }
        if (databaseType.contains("Country")) {
            types.add(ResponseType.COUNTRY);
        }
        if (types.isEmpty()) {
            throw new IllegalStateException("Unsupported database type: " + databaseType);
        }
        return Collections.unmodifiableSet(types);
    }

    public static final class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<GeoIP2DBConnectorPortObjectSpec> {
    }
}

