/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.ws;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.StringUtils;

class GeoIP2WSConnectorNodeSettings {
    static final String KEY_ACCOUNT_ID = "accountId";
    static final String KEY_LICENSE_KEY = "licenseKey";
    private final SettingsModelString accountId = new SettingsModelString("accountId", null);
    private final SettingsModelString licenseKey = new SettingsModelString("licenseKey", null);

    GeoIP2WSConnectorNodeSettings() {
    }

    public SettingsModelString getSettingAccountID() {
        return this.accountId;
    }

    public SettingsModelString getSettingLicenseKey() {
        return this.licenseKey;
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.accountId.saveSettingsTo(settings);
        this.licenseKey.saveSettingsTo(settings);
    }

    public void loadSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.accountId.loadSettingsFrom(settings);
        this.licenseKey.loadSettingsFrom(settings);
    }

    public void validateSettings() throws InvalidSettingsException {
        String accountId = this.getSettingAccountID().getStringValue();
        if (StringUtils.nullOrEmpty((String)accountId)) {
            throw new InvalidSettingsException("Account ID is missing.");
        }
        try {
            Integer.parseInt(accountId);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidSettingsException("Account ID must only consist of digits.");
        }
        if (StringUtils.nullOrEmpty((String)this.getSettingLicenseKey().getStringValue())) {
            throw new InvalidSettingsException("License key is missing.");
        }
    }
}

