/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.maxmind.geoip2.connector.ws;

import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AbstractResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.AbstractGeoIP2ConnectorPortObjectSpec;
import ws.palladian.nodes.maxmind.geoip2.connector.port.GeoIP2Extractor;
import ws.palladian.nodes.maxmind.geoip2.connector.port.ResponseType;
import ws.palladian.nodes.maxmind.geoip2.connector.ws.GeoIP2WSConnectorNodeSettings;

public final class GeoIP2WSConnectorPortObjectSpec
extends AbstractGeoIP2ConnectorPortObjectSpec {
    private String accountId;
    private String licenseKey;

    public GeoIP2WSConnectorPortObjectSpec() {
    }

    GeoIP2WSConnectorPortObjectSpec(GeoIP2WSConnectorNodeSettings nodeSettings) {
        this.accountId = nodeSettings.getSettingAccountID().getStringValue();
        this.licenseKey = nodeSettings.getSettingLicenseKey().getStringValue();
    }

    protected void save(ModelContentWO model) {
        model.addString("accountId", this.accountId);
        model.addString("licenseKey", this.licenseKey);
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.accountId = model.getString("accountId");
        this.licenseKey = model.getString("licenseKey");
    }

    @Override
    protected String getSummary() {
        return "Account ID: " + this.accountId;
    }

    @Override
    public Set<? extends ResponseType> getSupportedResponseTypes() {
        return Collections.unmodifiableSet(new LinkedHashSet<ResponseType>(Arrays.asList(ResponseType.COUNTRY, ResponseType.CITY, ResponseType.INSIGHTS)));
    }

    @Override
    public GeoIP2Extractor createExtractor(final ResponseType type) throws Exception {
        final WebServiceClient webserviceClient = this.getWebserviceClient();
        return new GeoIP2Extractor(){

            @Override
            public AbstractResponse execute(InetAddress ipAddress) throws IOException, GeoIp2Exception {
                switch (type) {
                    case CITY: {
                        return webserviceClient.city(ipAddress);
                    }
                    case COUNTRY: {
                        return webserviceClient.country(ipAddress);
                    }
                    case INSIGHTS: {
                        return webserviceClient.insights(ipAddress);
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public void close() throws Exception {
            }
        };
    }

    private WebServiceClient getWebserviceClient() {
        return new WebServiceClient.Builder(Integer.parseInt(this.accountId), this.licenseKey).build();
    }

    public static final class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<GeoIP2WSConnectorPortObjectSpec> {
    }
}

