/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.cloud.azure.storage.httpheaders;

import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import ws.palladian.nodes.cloud.azure.storage.httpheaders.AzureStorageHttpHeadersNodeSettings;

class AzureStorageHttpHeadersNodeDialog
extends DefaultNodeSettingsPane {
    private final AzureStorageHttpHeadersNodeSettings settings = new AzureStorageHttpHeadersNodeSettings();

    public AzureStorageHttpHeadersNodeDialog() {
        this.createNewGroup("Input");
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.blobContainerName, "Blob Container Name", true, 30));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.fileNamePattern, "File Name Pattern", true, 30));
        this.createNewGroup("HTTP Headers");
        this.addHeaderConfig(this.settings.contentLanguage, "Content Language");
        this.addHeaderConfig(this.settings.contentType, "Content Type");
        this.addHeaderConfig(this.settings.cacheControl, "Cache Control");
        this.addHeaderConfig(this.settings.contentDisposition, "Content Disposition");
        this.addHeaderConfig(this.settings.contentEncoding, "Content Encoding");
    }

    private void addHeaderConfig(AzureStorageHttpHeadersNodeSettings.SettingsPair settingsPair, String label) {
        this.setHorizontalPlacement(true);
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(settingsPair.active, label));
        this.addDialogComponent((DialogComponent)new DialogComponentString(settingsPair.value, "", false, 30));
        this.setHorizontalPlacement(false);
    }
}

