/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.StringHelpers;
import java.io.IOException;
import java.util.Map;
import ws.palladian.nodes.templating.TemplateEngine;

class HandlebarsTemplateEngine
implements TemplateEngine {
    private static final String DEFAULT_SNIPPET = "<html>\n  <head>\n    <title>Handlebars Node</title>\n  </head>\n  <body>\n    <h1>Hello world!</h1>\n  </body>\n</html>";

    HandlebarsTemplateEngine() {
    }

    public String applyTemplate(String templateString, Map<String, Object> context) throws IOException {
        Context handlebarsContext = Context.newBuilder(context).build();
        Template template = new Handlebars().prettyPrint(true).registerHelpers(StringHelpers.class).registerHelpers(ConditionalHelpers.class).compileInline(templateString);
        return template.apply(handlebarsContext);
    }

    public String getDefaultSnippet() {
        return DEFAULT_SNIPPET;
    }

    public String getName() {
        return "Handlebars";
    }
}

