/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.collection.jaccard;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Set;
import java.util.stream.Collectors;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.collection.CollectionDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.metrics.GeneralizedJaccard;
import ws.palladian.nodes.distances.collection.jaccard.JaccardConfig;

final class Jaccard
extends SingleColumnDistanceMeasure<JaccardConfig> {
    Jaccard(JaccardConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        CollectionDataValue value1 = (CollectionDataValue)this.checkNotMissing(row1, this.getIndex(), CollectionDataValue.class);
        CollectionDataValue value2 = (CollectionDataValue)this.checkNotMissing(row2, this.getIndex(), CollectionDataValue.class);
        if (((JaccardConfig)this.getConfig()).generalized) {
            return Jaccard.calculateGeneralizedJaccard(value1, value2);
        }
        return Jaccard.calculateJaccard(value1, value2);
    }

    private static double calculateJaccard(CollectionDataValue value1, CollectionDataValue value2) {
        Set set1 = value1.stream().collect(Collectors.toSet());
        Set set2 = value2.stream().collect(Collectors.toSet());
        org.simmetrics.metrics.Jaccard distance = new org.simmetrics.metrics.Jaccard();
        return distance.distance(set1, set2);
    }

    private static double calculateGeneralizedJaccard(CollectionDataValue value1, CollectionDataValue value2) {
        HashMultiset set1 = value1.stream().collect(Collectors.toCollection(HashMultiset::create));
        HashMultiset set2 = value2.stream().collect(Collectors.toCollection(HashMultiset::create));
        GeneralizedJaccard distance = new GeneralizedJaccard();
        return distance.distance((Multiset)set1, (Multiset)set2);
    }
}

