/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.dameraulevenshtein;

import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import ws.palladian.nodes.distances.string.dameraulevenshtein.DamerauLevenshteinConfig;

final class DamerauLevenshtein
extends SingleColumnDistanceMeasure<DamerauLevenshteinConfig> {
    DamerauLevenshtein(DamerauLevenshteinConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        String value1 = ((StringValue)this.checkNotMissing(row1, this.getIndex(), StringValue.class)).getStringValue();
        String value2 = ((StringValue)this.checkNotMissing(row2, this.getIndex(), StringValue.class)).getStringValue();
        DamerauLevenshteinConfig config = (DamerauLevenshteinConfig)this.getConfig();
        org.simmetrics.metrics.DamerauLevenshtein damerauLevenshtein = new org.simmetrics.metrics.DamerauLevenshtein((float)config.insertDelete, (float)config.substitute, (float)config.transpose);
        if (((DamerauLevenshteinConfig)this.getConfig()).normalized) {
            return 1.0f - damerauLevenshtein.compare(value1, value2);
        }
        return damerauLevenshtein.distance(value1, value2);
    }
}

