/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.needlemanwunsch;

import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.metrics.NeedlemanWunch;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;
import ws.palladian.nodes.distances.string.needlemanwunsch.NeedlemanWunschConfig;

final class NeedlemanWunsch
extends SingleColumnDistanceMeasure<NeedlemanWunschConfig> {
    NeedlemanWunsch(NeedlemanWunschConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        String value1 = ((StringValue)this.checkNotMissing(row1, this.getIndex(), StringValue.class)).getStringValue();
        String value2 = ((StringValue)this.checkNotMissing(row2, this.getIndex(), StringValue.class)).getStringValue();
        NeedlemanWunschConfig config = (NeedlemanWunschConfig)this.getConfig();
        MatchMismatch substitution = new MatchMismatch((float)config.matchValue, (float)config.mismatchValue);
        NeedlemanWunch needlemanWunch = new NeedlemanWunch((float)config.gapValue, (Substitution)substitution);
        return needlemanWunch.compare(value1, value2);
    }
}

