/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.string.smithwatermangotoh;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.category.DistanceCategorySubPanel;
import ws.palladian.nodes.distances.string.smithwatermangotoh.SmithWatermanGotohConfig;

final class SmithWatermanGotohPanel
extends DistanceCategorySubPanel<SmithWatermanGotohConfig> {
    private static final long serialVersionUID = 1L;
    private final JSpinner gap = new JSpinner(new SpinnerNumberModel(-0.5, -1000.0, 0.0, 0.1));
    private final JSpinner match = new JSpinner(new SpinnerNumberModel(1.0, -1000.0, 1000.0, 0.1));
    private final JSpinner mismatch = new JSpinner(new SpinnerNumberModel(-2.0, -1000.0, 1000.0, 0.1));

    SmithWatermanGotohPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.add(this.createPanel(), "West");
    }

    private Component createPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(new JLabel("Gap value:   "));
        panel.add(this.gap);
        panel.add(new JLabel("Score when characters are equal:   "));
        panel.add(this.match);
        panel.add(new JLabel("Score when characters are not equal:   "));
        panel.add(this.mismatch);
        return panel;
    }

    protected SmithWatermanGotohConfig getConfig() throws InvalidSettingsException {
        double mismatchValue;
        double gapValue = (Double)this.gap.getValue();
        double matchValue = (Double)this.match.getValue();
        if (matchValue <= (mismatchValue = ((Double)this.mismatch.getValue()).doubleValue())) {
            throw new InvalidSettingsException("The matchValue must be strictly greater then mismatchValue");
        }
        return new SmithWatermanGotohConfig(gapValue, matchValue, mismatchValue);
    }

    protected void loadConfig(SmithWatermanGotohConfig config) {
        SmithWatermanGotohConfig configNotNull = config == null ? new SmithWatermanGotohConfig() : config;
        this.gap.setValue(configNotNull.gapValue);
        this.match.setValue(configNotNull.matchValue);
        this.mismatch.setValue(configNotNull.mismatchValue);
    }
}

