/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.source.geonames;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.extraction.location.sources.GeonamesLocationSource;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.extraction.location.source.LocationSourceFactory;
import ws.palladian.nodes.extraction.location.source.LocationSourceSetting;
import ws.palladian.nodes.extraction.location.source.geonames.Activator;
import ws.palladian.nodes.extraction.location.source.preferences.AbstractSourceSettingWizardPage;

@Deprecated
public final class GeonamesLocationSourceFactory
implements LocationSourceFactory {
    private static final String TYPE_IDENTIFIER = "ws.palladian.nodes.extraction.location.source.GeonamesSourceFactory";
    private static final String DESCRIPTION = "Geonames-based Location Source";
    private static final String ICON_PATH = "/resources/geonames.png";
    private static final String USERNAME_KEY = "geonames.username";
    private static final String RETRIEVE_HIERARCHY_KEY = "geonames.retrieveHierarchy";
    private static final String MESSAGE_LABEL_TEST_REQUEST = "Use the \"Test\" button to perform a test request on Geonames.";

    public String getTypeIdentifier() {
        return TYPE_IDENTIFIER;
    }

    public String getReadableDescription() {
        return DESCRIPTION;
    }

    public Image getIcon() {
        return Activator.getDefault().getImage(ICON_PATH);
    }

    public LocationSource createLocationSource(LocationSourceSetting setting) {
        String username = setting.getProperty(USERNAME_KEY);
        boolean retrieveHierarchy = Boolean.valueOf(setting.getProperty(RETRIEVE_HIERARCHY_KEY));
        return GeonamesLocationSource.newCachedLocationSource((String)username, (boolean)retrieveHierarchy);
    }

    public LocationSourceFactory.SourceSettingWizardPage getWizardPage(final LocationSourceSetting setting) {
        return new AbstractSourceSettingWizardPage(){
            private Text usernameInput;
            private Button buttonTest;
            private Label messageLabel;
            private Composite composite;
            private Button retrieveHierarchyCheckbox;

            public void createControl(Composite parent) {
                this.composite = new Composite(parent, 0);
                this.composite.setLayout((Layout)new GridLayout(2, false));
                this.setControl((Control)this.composite);
                GridData gridData = new GridData();
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalAlignment = 4;
                Label label = new Label(this.composite, 0);
                label.setText("Username");
                this.usernameInput = new Text(this.composite, 2048);
                this.usernameInput.setLayoutData((Object)gridData);
                new Label(this.composite, 0);
                this.retrieveHierarchyCheckbox = new Button(this.composite, 16480);
                this.retrieveHierarchyCheckbox.setText("Retrieve location hierarchy (this causes one additional request for each location found, but it can greatly improve results of the LocationExtractor).");
                gridData = new GridData(768);
                gridData.widthHint = 400;
                this.retrieveHierarchyCheckbox.setLayoutData((Object)gridData);
                new Label(this.composite, 0);
                Link link = new Link(this.composite, 16448);
                link.setText("Geonames allows 30,000 REST requests/day, and 2,000 REST requests/hour when using a free account. A new account can be created <a href=\"http://www.geonames.org/login\">here</a>, afterwards go to <a href=\"http://www.geonames.org/manageaccount\">this</a> link and enable the usage of \"Free Web Services\".");
                gridData = new GridData(768);
                gridData.widthHint = 400;
                link.setLayoutData((Object)gridData);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                        }
                        catch (PartInitException partInitException) {
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                });
                if (setting != null) {
                    if (setting.getProperty(GeonamesLocationSourceFactory.USERNAME_KEY) != null) {
                        this.usernameInput.setText(setting.getProperty(GeonamesLocationSourceFactory.USERNAME_KEY));
                    }
                    if (setting.getProperty(GeonamesLocationSourceFactory.RETRIEVE_HIERARCHY_KEY) != null) {
                        this.retrieveHierarchyCheckbox.setSelection(Boolean.valueOf(setting.getProperty(GeonamesLocationSourceFactory.RETRIEVE_HIERARCHY_KEY)).booleanValue());
                    }
                }
                this.usernameInput.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.updateTestText(GeonamesLocationSourceFactory.MESSAGE_LABEL_TEST_REQUEST);
                        this.validate();
                    }
                });
                new Label(this.composite, 0);
                Composite testComposite = new Composite(this.composite, 0);
                testComposite.setLayout((Layout)new GridLayout(2, false));
                this.buttonTest = new Button(testComposite, 8);
                this.buttonTest.setText("Test");
                this.buttonTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String msg = GeonamesLocationSourceFactory.testGeonames(usernameInput.getText().trim());
                        this.updateTestText(msg);
                    }
                });
                this.messageLabel = new Label(testComposite, 16448);
                this.messageLabel.setText(GeonamesLocationSourceFactory.MESSAGE_LABEL_TEST_REQUEST);
                gridData = new GridData(768);
                gridData.widthHint = 350;
                this.messageLabel.setLayoutData((Object)gridData);
                this.validate();
            }

            public void getSettings(LocationSourceSetting setting2) {
                String username = this.usernameInput.getText().trim();
                setting2.setProperty(GeonamesLocationSourceFactory.USERNAME_KEY, username);
                boolean retrieveHierarchy = this.retrieveHierarchyCheckbox.getSelection();
                setting2.setProperty(GeonamesLocationSourceFactory.RETRIEVE_HIERARCHY_KEY, String.valueOf(retrieveHierarchy));
            }

            private void validate() {
                boolean valid = this.usernameInput.getText().trim().length() > 0;
                this.setPageComplete(valid);
                this.buttonTest.setEnabled(valid);
            }

            private void updateTestText(String msg) {
                this.messageLabel.setText(msg);
                this.composite.layout();
            }
        };
    }

    private static String testGeonames(String username) {
        Collection locations;
        if (username == null || username.isEmpty()) {
            return "Error: No username specified";
        }
        LocationSource source = GeonamesLocationSource.newCachedLocationSource((String)username);
        try {
            locations = source.getLocations("new york", EnumSet.of(Language.ENGLISH));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (locations.isEmpty()) {
            return "Error: Source did not return any locations for test request.";
        }
        return "Test successful.";
    }
}

