/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.collection.euclidean;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.stream.Collectors;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.collection.CollectionDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import ws.palladian.nodes.distances.collection.euclidean.EuclideanDistanceConfig;

final class EuclideanDistance
extends SingleColumnDistanceMeasure<EuclideanDistanceConfig> {
    EuclideanDistance(EuclideanDistanceConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        CollectionDataValue value1 = (CollectionDataValue)this.checkNotMissing(row1, this.getIndex(), CollectionDataValue.class);
        CollectionDataValue value2 = (CollectionDataValue)this.checkNotMissing(row2, this.getIndex(), CollectionDataValue.class);
        HashMultiset multiset1 = value1.stream().collect(Collectors.toCollection(HashMultiset::create));
        HashMultiset multiset2 = value2.stream().collect(Collectors.toCollection(HashMultiset::create));
        org.simmetrics.metrics.EuclideanDistance distance = new org.simmetrics.metrics.EuclideanDistance();
        if (((EuclideanDistanceConfig)this.getConfig()).normalized) {
            return 1.0f - distance.compare((Multiset)multiset1, (Multiset)multiset2);
        }
        return distance.distance((Multiset)multiset1, (Multiset)multiset2);
    }
}

