/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.distances.collection.overlap;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Set;
import java.util.stream.Collectors;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.collection.CollectionDataValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.distance.DistanceMeasureConfig;
import org.knime.distance.DistanceMeasurementException;
import org.knime.distance.SingleColumnDistanceMeasure;
import org.simmetrics.metrics.GeneralizedOverlapCoefficient;
import org.simmetrics.metrics.OverlapCoefficient;
import ws.palladian.nodes.distances.collection.overlap.OverlapConfig;

final class Overlap
extends SingleColumnDistanceMeasure<OverlapConfig> {
    Overlap(OverlapConfig config, DataTableSpec spec) throws InvalidSettingsException {
        super((DistanceMeasureConfig)config, spec);
    }

    public double computeDistance(DataRow row1, DataRow row2) throws DistanceMeasurementException {
        CollectionDataValue value1 = (CollectionDataValue)this.checkNotMissing(row1, this.getIndex(), CollectionDataValue.class);
        CollectionDataValue value2 = (CollectionDataValue)this.checkNotMissing(row2, this.getIndex(), CollectionDataValue.class);
        if (((OverlapConfig)this.getConfig()).generalized) {
            return Overlap.calculateGeneralizedOverlap(value1, value2);
        }
        return Overlap.calculateOverlap(value1, value2);
    }

    private static double calculateOverlap(CollectionDataValue value1, CollectionDataValue value2) {
        Set set1 = value1.stream().collect(Collectors.toSet());
        Set set2 = value2.stream().collect(Collectors.toSet());
        OverlapCoefficient overlapCoefficient = new OverlapCoefficient();
        return overlapCoefficient.distance(set1, set2);
    }

    private static double calculateGeneralizedOverlap(CollectionDataValue value1, CollectionDataValue value2) {
        HashMultiset set1 = value1.stream().collect(Collectors.toCollection(HashMultiset::create));
        HashMultiset set2 = value2.stream().collect(Collectors.toCollection(HashMultiset::create));
        GeneralizedOverlapCoefficient distance = new GeneralizedOverlapCoefficient();
        return 1.0f - distance.compare((Multiset)set1, (Multiset)set2);
    }
}

